import { AuthDto } from 'src/dtos/auth.dto';
import { NotificationCreateDto, NotificationDto, TemplateDto, TemplateResponseDto, TestEmailResponseDto } from 'src/dtos/notification.dto';
import { SystemConfigSmtpDto } from 'src/dtos/system-config.dto';
import { EmailTemplate } from 'src/repositories/email.repository';
import { NotificationAdminService } from 'src/services/notification-admin.service';
export declare class NotificationAdminController {
    private service;
    constructor(service: NotificationAdminService);
    createNotification(auth: AuthDto, dto: NotificationCreateDto): Promise<NotificationDto>;
    sendTestEmailAdmin(auth: AuthDto, dto: SystemConfigSmtpDto): Promise<TestEmailResponseDto>;
    getNotificationTemplateAdmin(auth: AuthDto, name: EmailTemplate, dto: TemplateDto): Promise<TemplateResponseDto>;
}
