import { AuthDto } from 'src/dtos/auth.dto';
import { PartnerCreateDto, PartnerResponseDto, PartnerSearchDto, PartnerUpdateDto } from 'src/dtos/partner.dto';
import { PartnerService } from 'src/services/partner.service';
import { UUIDParamDto } from 'src/validation';
export declare class PartnerController {
    private service;
    constructor(service: PartnerService);
    getPartners(auth: AuthDto, dto: PartnerSearchDto): Promise<PartnerResponseDto[]>;
    createPartner(auth: AuthDto, dto: PartnerCreateDto): Promise<PartnerResponseDto>;
    createPartnerDeprecated(auth: AuthDto, { id }: UUIDParamDto): Promise<PartnerResponseDto>;
    updatePartner(auth: AuthDto, { id }: UUIDParamDto, dto: PartnerUpdateDto): Promise<PartnerResponseDto>;
    removePartner(auth: AuthDto, { id }: UUIDParamDto): Promise<void>;
}
