import { AuthDto } from 'src/dtos/auth.dto';
import { WorkflowCreateDto, WorkflowResponseDto, WorkflowUpdateDto } from 'src/dtos/workflow.dto';
import { WorkflowService } from 'src/services/workflow.service';
import { UUIDParamDto } from 'src/validation';
export declare class WorkflowController {
    private service;
    constructor(service: WorkflowService);
    createWorkflow(auth: AuthDto, dto: WorkflowCreateDto): Promise<WorkflowResponseDto>;
    getWorkflows(auth: AuthDto): Promise<WorkflowResponseDto[]>;
    getWorkflow(auth: AuthDto, { id }: UUIDParamDto): Promise<WorkflowResponseDto>;
    updateWorkflow(auth: AuthDto, { id }: UUIDParamDto, dto: WorkflowUpdateDto): Promise<WorkflowResponseDto>;
    deleteWorkflow(auth: AuthDto, { id }: UUIDParamDto): Promise<void>;
}
