"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LibraryStatsResponseDto = exports.LibraryResponseDto = exports.LibrarySearchDto = exports.ValidateLibraryImportPathResponseDto = exports.ValidateLibraryResponseDto = exports.ValidateLibraryDto = exports.UpdateLibraryDto = exports.CreateLibraryDto = void 0;
exports.mapLibrary = mapLibrary;
const openapi = require("@nestjs/swagger");
const swagger_1 = require("@nestjs/swagger");
const class_validator_1 = require("class-validator");
const validation_1 = require("../validation");
class CreateLibraryDto {
    ownerId;
    name;
    importPaths;
    exclusionPatterns;
    static _OPENAPI_METADATA_FACTORY() {
        return { ownerId: { required: true, type: () => String }, name: { required: false, type: () => String }, importPaths: { required: false, type: () => [String], uniqueItems: true, maxItems: 128 }, exclusionPatterns: { required: false, type: () => [String], uniqueItems: true, maxItems: 128 } };
    }
}
exports.CreateLibraryDto = CreateLibraryDto;
__decorate([
    (0, validation_1.ValidateUUID)(),
    __metadata("design:type", String)
], CreateLibraryDto.prototype, "ownerId", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", String)
], CreateLibraryDto.prototype, "name", void 0);
__decorate([
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsString)({ each: true }),
    (0, class_validator_1.IsNotEmpty)({ each: true }),
    (0, class_validator_1.ArrayUnique)(),
    (0, class_validator_1.ArrayMaxSize)(128),
    __metadata("design:type", Array)
], CreateLibraryDto.prototype, "importPaths", void 0);
__decorate([
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsString)({ each: true }),
    (0, class_validator_1.IsNotEmpty)({ each: true }),
    (0, class_validator_1.ArrayUnique)(),
    (0, class_validator_1.ArrayMaxSize)(128),
    __metadata("design:type", Array)
], CreateLibraryDto.prototype, "exclusionPatterns", void 0);
class UpdateLibraryDto {
    name;
    importPaths;
    exclusionPatterns;
    static _OPENAPI_METADATA_FACTORY() {
        return { name: { required: false, type: () => String }, importPaths: { required: false, type: () => [String], uniqueItems: true, maxItems: 128 }, exclusionPatterns: { required: false, type: () => [String], uniqueItems: true, maxItems: 128 } };
    }
}
exports.UpdateLibraryDto = UpdateLibraryDto;
__decorate([
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", String)
], UpdateLibraryDto.prototype, "name", void 0);
__decorate([
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsString)({ each: true }),
    (0, class_validator_1.IsNotEmpty)({ each: true }),
    (0, class_validator_1.ArrayUnique)(),
    (0, class_validator_1.ArrayMaxSize)(128),
    __metadata("design:type", Array)
], UpdateLibraryDto.prototype, "importPaths", void 0);
__decorate([
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsNotEmpty)({ each: true }),
    (0, class_validator_1.IsString)({ each: true }),
    (0, class_validator_1.ArrayUnique)(),
    (0, class_validator_1.ArrayMaxSize)(128),
    __metadata("design:type", Array)
], UpdateLibraryDto.prototype, "exclusionPatterns", void 0);
class ValidateLibraryDto {
    importPaths;
    exclusionPatterns;
    static _OPENAPI_METADATA_FACTORY() {
        return { importPaths: { required: false, type: () => [String], uniqueItems: true, maxItems: 128 }, exclusionPatterns: { required: false, type: () => [String], uniqueItems: true, maxItems: 128 } };
    }
}
exports.ValidateLibraryDto = ValidateLibraryDto;
__decorate([
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsString)({ each: true }),
    (0, class_validator_1.IsNotEmpty)({ each: true }),
    (0, class_validator_1.ArrayUnique)(),
    (0, class_validator_1.ArrayMaxSize)(128),
    __metadata("design:type", Array)
], ValidateLibraryDto.prototype, "importPaths", void 0);
__decorate([
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsNotEmpty)({ each: true }),
    (0, class_validator_1.IsString)({ each: true }),
    (0, class_validator_1.ArrayUnique)(),
    (0, class_validator_1.ArrayMaxSize)(128),
    __metadata("design:type", Array)
], ValidateLibraryDto.prototype, "exclusionPatterns", void 0);
class ValidateLibraryResponseDto {
    importPaths;
    static _OPENAPI_METADATA_FACTORY() {
        return { importPaths: { required: false, type: () => [require("./library.dto").ValidateLibraryImportPathResponseDto] } };
    }
}
exports.ValidateLibraryResponseDto = ValidateLibraryResponseDto;
class ValidateLibraryImportPathResponseDto {
    importPath;
    isValid = false;
    message;
    static _OPENAPI_METADATA_FACTORY() {
        return { importPath: { required: true, type: () => String }, isValid: { required: true, type: () => Boolean, default: false }, message: { required: false, type: () => String } };
    }
}
exports.ValidateLibraryImportPathResponseDto = ValidateLibraryImportPathResponseDto;
class LibrarySearchDto {
    userId;
    static _OPENAPI_METADATA_FACTORY() {
        return { userId: { required: false, type: () => String } };
    }
}
exports.LibrarySearchDto = LibrarySearchDto;
__decorate([
    (0, validation_1.ValidateUUID)({ optional: true }),
    __metadata("design:type", String)
], LibrarySearchDto.prototype, "userId", void 0);
class LibraryResponseDto {
    id;
    ownerId;
    name;
    assetCount;
    importPaths;
    exclusionPatterns;
    createdAt;
    updatedAt;
    refreshedAt;
    static _OPENAPI_METADATA_FACTORY() {
        return { id: { required: true, type: () => String }, ownerId: { required: true, type: () => String }, name: { required: true, type: () => String }, assetCount: { required: true, type: () => Number }, importPaths: { required: true, type: () => [String] }, exclusionPatterns: { required: true, type: () => [String] }, createdAt: { required: true, type: () => Date }, updatedAt: { required: true, type: () => Date }, refreshedAt: { required: true, type: () => Date, nullable: true } };
    }
}
exports.LibraryResponseDto = LibraryResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Number)
], LibraryResponseDto.prototype, "assetCount", void 0);
class LibraryStatsResponseDto {
    photos = 0;
    videos = 0;
    total = 0;
    usage = 0;
    static _OPENAPI_METADATA_FACTORY() {
        return { photos: { required: true, type: () => Object, default: 0 }, videos: { required: true, type: () => Object, default: 0 }, total: { required: true, type: () => Object, default: 0 }, usage: { required: true, type: () => Object, default: 0 } };
    }
}
exports.LibraryStatsResponseDto = LibraryStatsResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Object)
], LibraryStatsResponseDto.prototype, "photos", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Object)
], LibraryStatsResponseDto.prototype, "videos", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Object)
], LibraryStatsResponseDto.prototype, "total", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer', format: 'int64' }),
    __metadata("design:type", Object)
], LibraryStatsResponseDto.prototype, "usage", void 0);
function mapLibrary(entity) {
    let assetCount = 0;
    if (entity.assets) {
        assetCount = entity.assets.length;
    }
    return {
        id: entity.id,
        ownerId: entity.ownerId,
        name: entity.name,
        createdAt: entity.createdAt,
        updatedAt: entity.updatedAt,
        refreshedAt: entity.refreshedAt,
        assetCount,
        importPaths: entity.importPaths,
        exclusionPatterns: entity.exclusionPatterns,
    };
}
//# sourceMappingURL=library.dto.js.map