"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PartnerResponseDto = exports.PartnerSearchDto = exports.PartnerUpdateDto = exports.PartnerCreateDto = void 0;
const openapi = require("@nestjs/swagger");
const class_validator_1 = require("class-validator");
const user_dto_1 = require("./user.dto");
const partner_repository_1 = require("../repositories/partner.repository");
const validation_1 = require("../validation");
class PartnerCreateDto {
    sharedWithId;
    static _OPENAPI_METADATA_FACTORY() {
        return { sharedWithId: { required: true, type: () => String } };
    }
}
exports.PartnerCreateDto = PartnerCreateDto;
__decorate([
    (0, validation_1.ValidateUUID)(),
    __metadata("design:type", String)
], PartnerCreateDto.prototype, "sharedWithId", void 0);
class PartnerUpdateDto {
    inTimeline;
    static _OPENAPI_METADATA_FACTORY() {
        return { inTimeline: { required: true, type: () => Boolean } };
    }
}
exports.PartnerUpdateDto = PartnerUpdateDto;
__decorate([
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", Boolean)
], PartnerUpdateDto.prototype, "inTimeline", void 0);
class PartnerSearchDto {
    direction;
    static _OPENAPI_METADATA_FACTORY() {
        return { direction: { required: true, enum: require("../repositories/partner.repository").PartnerDirection } };
    }
}
exports.PartnerSearchDto = PartnerSearchDto;
__decorate([
    (0, validation_1.ValidateEnum)({ enum: partner_repository_1.PartnerDirection, name: 'PartnerDirection' }),
    __metadata("design:type", String)
], PartnerSearchDto.prototype, "direction", void 0);
class PartnerResponseDto extends user_dto_1.UserResponseDto {
    inTimeline;
    static _OPENAPI_METADATA_FACTORY() {
        return { inTimeline: { required: false, type: () => Boolean } };
    }
}
exports.PartnerResponseDto = PartnerResponseDto;
//# sourceMappingURL=partner.dto.js.map