"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TagResponseDto = exports.TagBulkAssetsResponseDto = exports.TagBulkAssetsDto = exports.TagUpsertDto = exports.TagUpdateDto = exports.TagCreateDto = void 0;
exports.mapTag = mapTag;
const openapi = require("@nestjs/swagger");
const swagger_1 = require("@nestjs/swagger");
const class_validator_1 = require("class-validator");
const validation_1 = require("../validation");
class TagCreateDto {
    name;
    parentId;
    color;
    static _OPENAPI_METADATA_FACTORY() {
        return { name: { required: true, type: () => String }, parentId: { required: false, type: () => String, nullable: true }, color: { required: false, type: () => String, pattern: "^#?([0-9A-F]{3}|[0-9A-F]{4}|[0-9A-F]{6}|[0-9A-F]{8})$" } };
    }
}
exports.TagCreateDto = TagCreateDto;
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", String)
], TagCreateDto.prototype, "name", void 0);
__decorate([
    (0, validation_1.ValidateUUID)({ optional: true, nullable: true }),
    __metadata("design:type", Object)
], TagCreateDto.prototype, "parentId", void 0);
__decorate([
    (0, class_validator_1.IsHexColor)(),
    (0, validation_1.Optional)({ nullable: true, emptyToNull: true }),
    __metadata("design:type", String)
], TagCreateDto.prototype, "color", void 0);
class TagUpdateDto {
    color;
    static _OPENAPI_METADATA_FACTORY() {
        return { color: { required: false, type: () => String, nullable: true } };
    }
}
exports.TagUpdateDto = TagUpdateDto;
__decorate([
    (0, validation_1.Optional)({ emptyToNull: true, nullable: true }),
    (0, validation_1.ValidateHexColor)(),
    __metadata("design:type", Object)
], TagUpdateDto.prototype, "color", void 0);
class TagUpsertDto {
    tags;
    static _OPENAPI_METADATA_FACTORY() {
        return { tags: { required: true, type: () => [String] } };
    }
}
exports.TagUpsertDto = TagUpsertDto;
__decorate([
    (0, class_validator_1.IsString)({ each: true }),
    (0, class_validator_1.IsNotEmpty)({ each: true }),
    __metadata("design:type", Array)
], TagUpsertDto.prototype, "tags", void 0);
class TagBulkAssetsDto {
    tagIds;
    assetIds;
    static _OPENAPI_METADATA_FACTORY() {
        return { tagIds: { required: true, type: () => [String] }, assetIds: { required: true, type: () => [String] } };
    }
}
exports.TagBulkAssetsDto = TagBulkAssetsDto;
__decorate([
    (0, validation_1.ValidateUUID)({ each: true }),
    __metadata("design:type", Array)
], TagBulkAssetsDto.prototype, "tagIds", void 0);
__decorate([
    (0, validation_1.ValidateUUID)({ each: true }),
    __metadata("design:type", Array)
], TagBulkAssetsDto.prototype, "assetIds", void 0);
class TagBulkAssetsResponseDto {
    count;
    static _OPENAPI_METADATA_FACTORY() {
        return { count: { required: true, type: () => Number } };
    }
}
exports.TagBulkAssetsResponseDto = TagBulkAssetsResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Number)
], TagBulkAssetsResponseDto.prototype, "count", void 0);
class TagResponseDto {
    id;
    parentId;
    name;
    value;
    createdAt;
    updatedAt;
    color;
    static _OPENAPI_METADATA_FACTORY() {
        return { id: { required: true, type: () => String }, parentId: { required: false, type: () => String }, name: { required: true, type: () => String }, value: { required: true, type: () => String }, createdAt: { required: true, type: () => Date }, updatedAt: { required: true, type: () => Date }, color: { required: false, type: () => String } };
    }
}
exports.TagResponseDto = TagResponseDto;
function mapTag(entity) {
    return {
        id: entity.id,
        parentId: entity.parentId ?? undefined,
        name: entity.value.split('/').at(-1),
        value: entity.value,
        createdAt: entity.createdAt,
        updatedAt: entity.updatedAt,
        color: entity.color ?? undefined,
    };
}
//# sourceMappingURL=tag.dto.js.map