import { AssetOrder, AssetVisibility } from 'src/enum';
export declare class TimeBucketDto {
    userId?: string;
    albumId?: string;
    personId?: string;
    tagId?: string;
    isFavorite?: boolean;
    isTrashed?: boolean;
    withStacked?: boolean;
    withPartners?: boolean;
    order?: AssetOrder;
    visibility?: AssetVisibility;
    withCoordinates?: boolean;
}
export declare class TimeBucketAssetDto extends TimeBucketDto {
    timeBucket: string;
}
export declare class TimeBucketAssetResponseDto {
    id: string[];
    ownerId: string[];
    ratio: number[];
    isFavorite: boolean[];
    visibility: AssetVisibility[];
    isTrashed: boolean[];
    isImage: boolean[];
    thumbhash: (string | null)[];
    fileCreatedAt: string[];
    localOffsetHours: number[];
    duration: (string | null)[];
    stack?: ([string, string] | null)[];
    projectionType: (string | null)[];
    livePhotoVideoId: (string | null)[];
    city: (string | null)[];
    country: (string | null)[];
    latitude: number[];
    longitude: number[];
}
export declare class TimeBucketsResponseDto {
    timeBucket: string;
    count: number;
}
