"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MaintenanceWorkerService = void 0;
const common_1 = require("@nestjs/common");
const cookie_1 = require("cookie");
const jose_1 = require("jose");
const node_fs_1 = require("node:fs");
const enum_1 = require("../enum");
const maintenance_websocket_repository_1 = require("./maintenance-websocket.repository");
const app_repository_1 = require("../repositories/app.repository");
const config_repository_1 = require("../repositories/config.repository");
const logging_repository_1 = require("../repositories/logging.repository");
const system_metadata_repository_1 = require("../repositories/system-metadata.repository");
const config_1 = require("../utils/config");
const maintenance_1 = require("../utils/maintenance");
const misc_1 = require("../utils/misc");
let MaintenanceWorkerService = class MaintenanceWorkerService {
    logger;
    appRepository;
    configRepository;
    systemMetadataRepository;
    maintenanceWorkerRepository;
    constructor(logger, appRepository, configRepository, systemMetadataRepository, maintenanceWorkerRepository) {
        this.logger = logger;
        this.appRepository = appRepository;
        this.configRepository = configRepository;
        this.systemMetadataRepository = systemMetadataRepository;
        this.maintenanceWorkerRepository = maintenanceWorkerRepository;
        this.logger.setContext(this.constructor.name);
    }
    get configRepos() {
        return {
            configRepo: this.configRepository,
            metadataRepo: this.systemMetadataRepository,
            logger: this.logger,
        };
    }
    getConfig(options) {
        return (0, config_1.getConfig)(this.configRepos, options);
    }
    async getSystemConfig() {
        const config = await this.getConfig({ withCache: false });
        return {
            loginPageMessage: config.server.loginPageMessage,
            trashDays: config.trash.days,
            userDeleteDelay: config.user.deleteDelay,
            oauthButtonText: config.oauth.buttonText,
            isInitialized: true,
            isOnboarded: true,
            externalDomain: config.server.externalDomain,
            publicUsers: config.server.publicUsers,
            mapDarkStyleUrl: config.map.darkStyle,
            mapLightStyleUrl: config.map.lightStyle,
            maintenanceMode: true,
        };
    }
    ssr(excludePaths) {
        const { resourcePaths } = this.configRepository.getEnv();
        let index = '';
        try {
            index = (0, node_fs_1.readFileSync)(resourcePaths.web.indexHtml).toString();
        }
        catch {
            this.logger.warn(`Unable to open ${resourcePaths.web.indexHtml}, skipping SSR.`);
        }
        return (request, res, next) => {
            if (request.url.startsWith('/api') ||
                request.method.toLowerCase() !== 'get' ||
                excludePaths.some((item) => request.url.startsWith(item))) {
                return next();
            }
            const maintenancePath = '/maintenance';
            if (!request.url.startsWith(maintenancePath)) {
                const params = new URLSearchParams();
                params.set('continue', request.path);
                return res.redirect(`${maintenancePath}?${params}`);
            }
            res.status(200).type('text/html').header('Cache-Control', 'no-store').send(index);
        };
    }
    async secret() {
        const state = (await this.systemMetadataRepository.get(enum_1.SystemMetadataKey.MaintenanceMode));
        return state.secret;
    }
    async logSecret() {
        const { server } = await this.getConfig({ withCache: true });
        const baseUrl = (0, misc_1.getExternalDomain)(server);
        const url = await (0, maintenance_1.createMaintenanceLoginUrl)(baseUrl, {
            username: 'immich-admin',
        }, await this.secret());
        this.logger.log(`\n\n🚧 Immich is in maintenance mode, you can log in using the following URL:\n${url}\n`);
    }
    async authenticate(headers) {
        const jwtToken = (0, cookie_1.parse)(headers.cookie || '')[enum_1.ImmichCookie.MaintenanceToken];
        return this.login(jwtToken);
    }
    async login(jwt) {
        if (!jwt) {
            throw new common_1.UnauthorizedException('Missing JWT Token');
        }
        const secret = await this.secret();
        try {
            const result = await (0, jose_1.jwtVerify)(jwt, new TextEncoder().encode(secret));
            return result.payload;
        }
        catch {
            throw new common_1.UnauthorizedException('Invalid JWT Token');
        }
    }
    async endMaintenance() {
        const state = { isMaintenanceMode: false };
        await this.systemMetadataRepository.set(enum_1.SystemMetadataKey.MaintenanceMode, state);
        this.maintenanceWorkerRepository.clientBroadcast('AppRestartV1', state);
        this.maintenanceWorkerRepository.serverSend('AppRestart', state);
        this.appRepository.exitApp();
    }
};
exports.MaintenanceWorkerService = MaintenanceWorkerService;
exports.MaintenanceWorkerService = MaintenanceWorkerService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [logging_repository_1.LoggingRepository,
        app_repository_1.AppRepository,
        config_repository_1.ConfigRepository,
        system_metadata_repository_1.SystemMetadataRepository,
        maintenance_websocket_repository_1.MaintenanceWebsocketRepository])
], MaintenanceWorkerService);
//# sourceMappingURL=maintenance-worker.service.js.map