"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.pluginTriggers = void 0;
const enum_1 = require("./enum");
exports.pluginTriggers = [
    {
        name: 'Asset Uploaded',
        type: enum_1.PluginTriggerType.AssetCreate,
        description: 'Triggered when a new asset is uploaded',
        context: enum_1.PluginContext.Asset,
        schema: {
            type: 'object',
            properties: {
                assetType: {
                    type: 'string',
                    description: 'Type of the asset',
                    default: 'ALL',
                    enum: ['Image', 'Video', 'All'],
                },
            },
        },
    },
    {
        name: 'Person Recognized',
        type: enum_1.PluginTriggerType.PersonRecognized,
        description: 'Triggered when a person is detected in an asset',
        context: enum_1.PluginContext.Person,
        schema: null,
    },
];
//# sourceMappingURL=plugins.js.map