import { Kysely } from 'kysely';
import { DatabaseExtension, DatabaseLock, VectorIndex } from 'src/enum';
import { ConfigRepository } from 'src/repositories/config.repository';
import { LoggingRepository } from 'src/repositories/logging.repository';
import { DB } from 'src/schema';
import { ExtensionVersion, VectorExtension, VectorUpdateResult } from 'src/types';
export declare let cachedVectorExtension: VectorExtension | undefined;
export declare function getVectorExtension(runner: Kysely<DB>): Promise<VectorExtension>;
export declare const probes: Record<VectorIndex, number>;
export declare class DatabaseRepository {
    private db;
    private logger;
    private configRepository;
    private readonly asyncLock;
    constructor(db: Kysely<DB>, logger: LoggingRepository, configRepository: ConfigRepository);
    shutdown(): Promise<void>;
    getVectorExtension(): Promise<VectorExtension>;
    getExtensionVersions(extensions: readonly DatabaseExtension[]): Promise<ExtensionVersion[]>;
    getExtensionVersionRange(extension: VectorExtension): string;
    getPostgresVersion(): Promise<string>;
    getPostgresVersionRange(): string;
    createExtension(extension: DatabaseExtension): Promise<void>;
    dropExtension(extension: DatabaseExtension): Promise<void>;
    updateVectorExtension(extension: VectorExtension, targetVersion?: string): Promise<VectorUpdateResult>;
    prewarm(index: VectorIndex): Promise<void>;
    reindexVectorsIfNeeded(names: VectorIndex[]): Promise<void>;
    private reindexVectors;
    private setSearchPath;
    private getDatabaseName;
    getDimensionSize(table: string, column?: string): Promise<number>;
    setDimensionSize(dimSize: number): Promise<void>;
    deleteAllSearchEmbeddings(): Promise<void>;
    private targetListCount;
    private targetProbeCount;
    private getRowCount;
    runMigrations(): Promise<void>;
    migrateFilePaths(sourceFolder: string, targetFolder: string): Promise<void>;
    withLock<R>(lock: DatabaseLock, callback: () => Promise<R>): Promise<R>;
    tryLock(lock: DatabaseLock): Promise<boolean>;
    isBusy(lock: DatabaseLock): boolean;
    wait(lock: DatabaseLock): Promise<void>;
    private acquireLock;
    private acquireTryLock;
    private releaseLock;
    revertLastMigration(): Promise<string | undefined>;
    private createMigrator;
}
