import { Kysely } from 'kysely';
import { MapAsset } from 'src/dtos/asset-response.dto';
import { AssetType } from 'src/enum';
import { DB } from 'src/schema';
interface DuplicateSearch {
    assetId: string;
    embedding: string;
    maxDistance: number;
    type: AssetType;
    userIds: string[];
}
interface DuplicateMergeOptions {
    targetId: string | null;
    assetIds: string[];
    sourceIds: string[];
}
export declare class DuplicateRepository {
    private db;
    constructor(db: Kysely<DB>);
    getAll(userId: string): Promise<{
        assets: MapAsset[];
        duplicateId: string;
    }[]>;
    delete(userId: string, id: string): Promise<void>;
    deleteAll(userId: string, ids: string[]): Promise<void>;
    search({ assetId, embedding, maxDistance, type, userIds }: DuplicateSearch): Promise<{
        assetId: string;
        duplicateId: string | null;
        distance: number;
    }[]>;
    merge(options: DuplicateMergeOptions): Promise<void>;
}
export {};
