"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DuplicateRepository = void 0;
const common_1 = require("@nestjs/common");
const kysely_1 = require("kysely");
const nestjs_kysely_1 = require("nestjs-kysely");
const decorators_1 = require("../decorators");
const enum_1 = require("../enum");
const database_repository_1 = require("./database.repository");
const database_1 = require("../utils/database");
let DuplicateRepository = class DuplicateRepository {
    db;
    constructor(db) {
        this.db = db;
    }
    getAll(userId) {
        return (this.db
            .with('duplicates', (qb) => qb
            .selectFrom('asset')
            .$call(database_1.withDefaultVisibility)
            .innerJoinLateral((qb) => qb
            .selectFrom('asset_exif')
            .selectAll('asset')
            .select((eb) => eb.table('asset_exif').as('exifInfo'))
            .whereRef('asset_exif.assetId', '=', 'asset.id')
            .as('asset2'), (join) => join.onTrue())
            .select('asset.duplicateId')
            .select((eb) => eb.fn.jsonAgg('asset2').orderBy('asset.localDateTime', 'asc').$castTo().as('assets'))
            .where('asset.ownerId', '=', (0, database_1.asUuid)(userId))
            .where('asset.duplicateId', 'is not', null)
            .$narrowType()
            .where('asset.deletedAt', 'is', null)
            .where('asset.stackId', 'is', null)
            .groupBy('asset.duplicateId'))
            .with('unique', (qb) => qb
            .selectFrom('duplicates')
            .select('duplicateId')
            .where((eb) => eb(eb.fn('json_array_length', ['assets']), '=', 1)))
            .with('removed_unique', (qb) => qb
            .updateTable('asset')
            .set({ duplicateId: null })
            .from('unique')
            .whereRef('asset.duplicateId', '=', 'unique.duplicateId'))
            .selectFrom('duplicates')
            .selectAll()
            .where(({ not, exists }) => not(exists((eb) => eb.selectFrom('unique').whereRef('unique.duplicateId', '=', 'duplicates.duplicateId'))))
            .execute());
    }
    async delete(userId, id) {
        await this.db
            .updateTable('asset')
            .set({ duplicateId: null })
            .where('ownerId', '=', userId)
            .where('duplicateId', '=', id)
            .execute();
    }
    async deleteAll(userId, ids) {
        if (ids.length === 0) {
            return;
        }
        await this.db
            .updateTable('asset')
            .set({ duplicateId: null })
            .where('ownerId', '=', userId)
            .where('duplicateId', 'in', ids)
            .execute();
    }
    search({ assetId, embedding, maxDistance, type, userIds }) {
        return this.db.transaction().execute(async (trx) => {
            await (0, kysely_1.sql) `set local vchordrq.probes = ${kysely_1.sql.lit(database_repository_1.probes[enum_1.VectorIndex.Clip])}`.execute(trx);
            return await trx
                .with('cte', (qb) => qb
                .selectFrom('asset')
                .$call(database_1.withDefaultVisibility)
                .select([
                'asset.id as assetId',
                'asset.duplicateId',
                (0, kysely_1.sql) `smart_search.embedding <=> ${embedding}`.as('distance'),
            ])
                .innerJoin('smart_search', 'asset.id', 'smart_search.assetId')
                .where('asset.ownerId', '=', (0, database_1.anyUuid)(userIds))
                .where('asset.deletedAt', 'is', null)
                .where('asset.type', '=', type)
                .where('asset.id', '!=', (0, database_1.asUuid)(assetId))
                .where('asset.stackId', 'is', null)
                .orderBy('distance')
                .limit(64))
                .selectFrom('cte')
                .selectAll()
                .where('cte.distance', '<=', maxDistance)
                .execute();
        });
    }
    async merge(options) {
        await this.db
            .updateTable('asset')
            .set({ duplicateId: options.targetId })
            .where((eb) => eb.or([eb('duplicateId', '=', (0, database_1.anyUuid)(options.sourceIds)), eb('id', '=', (0, database_1.anyUuid)(options.assetIds))]))
            .execute();
    }
};
exports.DuplicateRepository = DuplicateRepository;
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], DuplicateRepository.prototype, "getAll", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", Promise)
], DuplicateRepository.prototype, "delete", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, [decorators_1.DummyValue.UUID]] }),
    (0, decorators_1.Chunked)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Array]),
    __metadata("design:returntype", Promise)
], DuplicateRepository.prototype, "deleteAll", null);
__decorate([
    (0, decorators_1.GenerateSql)({
        params: [
            {
                assetId: decorators_1.DummyValue.UUID,
                embedding: decorators_1.DummyValue.VECTOR,
                maxDistance: 0.6,
                type: enum_1.AssetType.Image,
                userIds: [decorators_1.DummyValue.UUID],
            },
        ],
    }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], DuplicateRepository.prototype, "search", null);
__decorate([
    (0, decorators_1.GenerateSql)({
        params: [{ targetDuplicateId: decorators_1.DummyValue.UUID, duplicateIds: [decorators_1.DummyValue.UUID], assetIds: [decorators_1.DummyValue.UUID] }],
    }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], DuplicateRepository.prototype, "merge", null);
exports.DuplicateRepository = DuplicateRepository = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, nestjs_kysely_1.InjectKysely)()),
    __metadata("design:paramtypes", [kysely_1.Kysely])
], DuplicateRepository);
//# sourceMappingURL=duplicate.repository.js.map