import { Insertable, Kysely, Updateable } from 'kysely';
import { PathType } from 'src/enum';
import { DB } from 'src/schema';
import { MoveTable } from 'src/schema/tables/move.table';
export declare class MoveRepository {
    private db;
    constructor(db: Kysely<DB>);
    create(entity: Insertable<MoveTable>): Promise<{
        id: string;
        entityId: string;
        pathType: PathType;
        newPath: string;
        oldPath: string;
    }>;
    getByEntity(entityId: string, pathType: PathType): Promise<{
        id: string;
        entityId: string;
        pathType: PathType;
        newPath: string;
        oldPath: string;
    } | undefined>;
    update(id: string, entity: Updateable<MoveTable>): Promise<{
        id: string;
        entityId: string;
        pathType: PathType;
        newPath: string;
        oldPath: string;
    }>;
    delete(id: string): Promise<{
        id: string;
        entityId: string;
        pathType: PathType;
        newPath: string;
        oldPath: string;
    }>;
    cleanMoveHistory(): Promise<void>;
    cleanMoveHistorySingle(assetId: string): Promise<void>;
}
