"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MoveRepository = void 0;
const common_1 = require("@nestjs/common");
const kysely_1 = require("kysely");
const nestjs_kysely_1 = require("nestjs-kysely");
const decorators_1 = require("../decorators");
const enum_1 = require("../enum");
let MoveRepository = class MoveRepository {
    db;
    constructor(db) {
        this.db = db;
    }
    create(entity) {
        return this.db.insertInto('move_history').values(entity).returningAll().executeTakeFirstOrThrow();
    }
    getByEntity(entityId, pathType) {
        return this.db
            .selectFrom('move_history')
            .selectAll()
            .where('entityId', '=', entityId)
            .where('pathType', '=', pathType)
            .executeTakeFirst();
    }
    update(id, entity) {
        return this.db
            .updateTable('move_history')
            .set(entity)
            .where('id', '=', id)
            .returningAll()
            .executeTakeFirstOrThrow();
    }
    delete(id) {
        return this.db.deleteFrom('move_history').where('id', '=', id).returningAll().executeTakeFirstOrThrow();
    }
    async cleanMoveHistory() {
        await this.db
            .deleteFrom('move_history')
            .where((eb) => eb('move_history.entityId', 'not in', eb.selectFrom('asset').select('id').whereRef('asset.id', '=', 'move_history.entityId')))
            .where('move_history.pathType', '=', kysely_1.sql.lit(enum_1.AssetPathType.Original))
            .execute();
    }
    async cleanMoveHistorySingle(assetId) {
        await this.db
            .deleteFrom('move_history')
            .where('move_history.pathType', '=', kysely_1.sql.lit(enum_1.AssetPathType.Original))
            .where('entityId', '=', assetId)
            .execute();
    }
};
exports.MoveRepository = MoveRepository;
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.STRING] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", void 0)
], MoveRepository.prototype, "getByEntity", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], MoveRepository.prototype, "delete", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], MoveRepository.prototype, "cleanMoveHistorySingle", null);
exports.MoveRepository = MoveRepository = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, nestjs_kysely_1.InjectKysely)()),
    __metadata("design:paramtypes", [kysely_1.Kysely])
], MoveRepository);
//# sourceMappingURL=move.repository.js.map