"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SharedLinkAssetRepository = void 0;
const kysely_1 = require("kysely");
const nestjs_kysely_1 = require("nestjs-kysely");
const decorators_1 = require("../decorators");
let SharedLinkAssetRepository = class SharedLinkAssetRepository {
    db;
    constructor(db) {
        this.db = db;
    }
    async remove(sharedLinkId, assetId) {
        const deleted = await this.db
            .deleteFrom('shared_link_asset')
            .where('shared_link_asset.sharedLinkId', '=', sharedLinkId)
            .where('shared_link_asset.assetId', 'in', assetId)
            .returning('assetId')
            .execute();
        return deleted.map((row) => row.assetId);
    }
    async copySharedLinks({ sourceAssetId, targetAssetId }) {
        return this.db
            .insertInto('shared_link_asset')
            .expression((eb) => eb
            .selectFrom('shared_link_asset')
            .select((eb) => [eb.val(targetAssetId).as('assetId'), 'shared_link_asset.sharedLinkId'])
            .where('shared_link_asset.assetId', '=', sourceAssetId))
            .onConflict((oc) => oc.doNothing())
            .execute();
    }
};
exports.SharedLinkAssetRepository = SharedLinkAssetRepository;
__decorate([
    (0, decorators_1.GenerateSql)({ params: [{ sourceAssetId: decorators_1.DummyValue.UUID, targetAssetId: decorators_1.DummyValue.UUID }] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], SharedLinkAssetRepository.prototype, "copySharedLinks", null);
exports.SharedLinkAssetRepository = SharedLinkAssetRepository = __decorate([
    __param(0, (0, nestjs_kysely_1.InjectKysely)()),
    __metadata("design:paramtypes", [kysely_1.Kysely])
], SharedLinkAssetRepository);
//# sourceMappingURL=shared-link-asset.repository.js.map