import { Insertable, Kysely, Updateable } from 'kysely';
import { DateTime } from 'luxon';
import { UserStatus } from 'src/enum';
import { DB } from 'src/schema';
import { UserTable } from 'src/schema/tables/user.table';
import { UserMetadata, UserMetadataItem } from 'src/types';
export interface UserListFilter {
    id?: string;
    withDeleted?: boolean;
}
export interface UserStatsQueryResponse {
    userId: string;
    userName: string;
    photos: number;
    videos: number;
    usage: number;
    usagePhotos: number;
    usageVideos: number;
    quotaSizeInBytes: number | null;
}
export interface UserFindOptions {
    withDeleted?: boolean;
}
export declare class UserRepository {
    private db;
    constructor(db: Kysely<DB>);
    get(userId: string, options: UserFindOptions): Promise<{
        id: string;
        name: string;
        email: string;
        updatedAt: Date;
        createdAt: Date;
        profileImagePath: string;
        isAdmin: boolean;
        shouldChangePassword: boolean;
        avatarColor: import("src/enum").UserAvatarColor | null;
        deletedAt: Date | null;
        oauthId: string;
        storageLabel: string | null;
        quotaSizeInBytes: number | null;
        quotaUsageInBytes: number;
        status: UserStatus;
        profileChangedAt: Date;
        metadata: {
            key: import("src/enum").UserMetadataKey;
            value: {
                isOnboarded: boolean;
            } | {
                licenseKey: string;
                activationKey: string;
                activatedAt: string;
            } | {
                albums?: {
                    defaultAssetOrder?: import("src/enum").AssetOrder | undefined;
                } | undefined;
                folders?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                memories?: {
                    enabled?: boolean | undefined;
                    duration?: number | undefined;
                } | undefined;
                people?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                ratings?: {
                    enabled?: boolean | undefined;
                } | undefined;
                sharedLinks?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                tags?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                emailNotifications?: {
                    enabled?: boolean | undefined;
                    albumInvite?: boolean | undefined;
                    albumUpdate?: boolean | undefined;
                } | undefined;
                download?: {
                    archiveSize?: number | undefined;
                    includeEmbeddedVideos?: boolean | undefined;
                } | undefined;
                purchase?: {
                    showSupportBadge?: boolean | undefined;
                    hideBuyButtonUntil?: string | undefined;
                } | undefined;
                cast?: {
                    gCastEnabled?: boolean | undefined;
                } | undefined;
            };
        }[];
    } | undefined>;
    getMetadata(userId: string): Promise<UserMetadataItem[]>;
    getAdmin(): Promise<{
        id: string;
        name: string;
        email: string;
        updatedAt: Date;
        createdAt: Date;
        profileImagePath: string;
        isAdmin: boolean;
        shouldChangePassword: boolean;
        avatarColor: import("src/enum").UserAvatarColor | null;
        deletedAt: Date | null;
        oauthId: string;
        storageLabel: string | null;
        quotaSizeInBytes: number | null;
        quotaUsageInBytes: number;
        status: UserStatus;
        profileChangedAt: Date;
        metadata: {
            key: import("src/enum").UserMetadataKey;
            value: {
                isOnboarded: boolean;
            } | {
                licenseKey: string;
                activationKey: string;
                activatedAt: string;
            } | {
                albums?: {
                    defaultAssetOrder?: import("src/enum").AssetOrder | undefined;
                } | undefined;
                folders?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                memories?: {
                    enabled?: boolean | undefined;
                    duration?: number | undefined;
                } | undefined;
                people?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                ratings?: {
                    enabled?: boolean | undefined;
                } | undefined;
                sharedLinks?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                tags?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                emailNotifications?: {
                    enabled?: boolean | undefined;
                    albumInvite?: boolean | undefined;
                    albumUpdate?: boolean | undefined;
                } | undefined;
                download?: {
                    archiveSize?: number | undefined;
                    includeEmbeddedVideos?: boolean | undefined;
                } | undefined;
                purchase?: {
                    showSupportBadge?: boolean | undefined;
                    hideBuyButtonUntil?: string | undefined;
                } | undefined;
                cast?: {
                    gCastEnabled?: boolean | undefined;
                } | undefined;
            };
        }[];
    } | undefined>;
    getFileSamples(): Promise<{
        id: string;
        profileImagePath: string;
    }[]>;
    hasAdmin(): Promise<boolean>;
    getForPinCode(id: string): Promise<{
        password: string;
        pinCode: string | null;
    }>;
    getForChangePassword(id: string): Promise<{
        password: string;
        id: string;
    }>;
    getByEmail(email: string, options?: {
        withPassword?: boolean;
    }): Promise<{
        id: string;
        name: string;
        email: string;
        updatedAt: Date;
        createdAt: Date;
        profileImagePath: string;
        isAdmin: boolean;
        shouldChangePassword: boolean;
        avatarColor: import("src/enum").UserAvatarColor | null;
        deletedAt: Date | null;
        oauthId: string;
        storageLabel: string | null;
        quotaSizeInBytes: number | null;
        quotaUsageInBytes: number;
        status: UserStatus;
        profileChangedAt: Date;
        metadata: {
            key: import("src/enum").UserMetadataKey;
            value: {
                isOnboarded: boolean;
            } | {
                licenseKey: string;
                activationKey: string;
                activatedAt: string;
            } | {
                albums?: {
                    defaultAssetOrder?: import("src/enum").AssetOrder | undefined;
                } | undefined;
                folders?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                memories?: {
                    enabled?: boolean | undefined;
                    duration?: number | undefined;
                } | undefined;
                people?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                ratings?: {
                    enabled?: boolean | undefined;
                } | undefined;
                sharedLinks?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                tags?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                emailNotifications?: {
                    enabled?: boolean | undefined;
                    albumInvite?: boolean | undefined;
                    albumUpdate?: boolean | undefined;
                } | undefined;
                download?: {
                    archiveSize?: number | undefined;
                    includeEmbeddedVideos?: boolean | undefined;
                } | undefined;
                purchase?: {
                    showSupportBadge?: boolean | undefined;
                    hideBuyButtonUntil?: string | undefined;
                } | undefined;
                cast?: {
                    gCastEnabled?: boolean | undefined;
                } | undefined;
            };
        }[];
        password?: string | undefined;
    } | undefined>;
    getByStorageLabel(storageLabel: string): Promise<{
        id: string;
        name: string;
        email: string;
        updatedAt: Date;
        createdAt: Date;
        profileImagePath: string;
        isAdmin: boolean;
        shouldChangePassword: boolean;
        avatarColor: import("src/enum").UserAvatarColor | null;
        deletedAt: Date | null;
        oauthId: string;
        storageLabel: string | null;
        quotaSizeInBytes: number | null;
        quotaUsageInBytes: number;
        status: UserStatus;
        profileChangedAt: Date;
    } | undefined>;
    getByOAuthId(oauthId: string): Promise<{
        id: string;
        name: string;
        email: string;
        updatedAt: Date;
        createdAt: Date;
        profileImagePath: string;
        isAdmin: boolean;
        shouldChangePassword: boolean;
        avatarColor: import("src/enum").UserAvatarColor | null;
        deletedAt: Date | null;
        oauthId: string;
        storageLabel: string | null;
        quotaSizeInBytes: number | null;
        quotaUsageInBytes: number;
        status: UserStatus;
        profileChangedAt: Date;
        metadata: {
            key: import("src/enum").UserMetadataKey;
            value: {
                isOnboarded: boolean;
            } | {
                licenseKey: string;
                activationKey: string;
                activatedAt: string;
            } | {
                albums?: {
                    defaultAssetOrder?: import("src/enum").AssetOrder | undefined;
                } | undefined;
                folders?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                memories?: {
                    enabled?: boolean | undefined;
                    duration?: number | undefined;
                } | undefined;
                people?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                ratings?: {
                    enabled?: boolean | undefined;
                } | undefined;
                sharedLinks?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                tags?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                emailNotifications?: {
                    enabled?: boolean | undefined;
                    albumInvite?: boolean | undefined;
                    albumUpdate?: boolean | undefined;
                } | undefined;
                download?: {
                    archiveSize?: number | undefined;
                    includeEmbeddedVideos?: boolean | undefined;
                } | undefined;
                purchase?: {
                    showSupportBadge?: boolean | undefined;
                    hideBuyButtonUntil?: string | undefined;
                } | undefined;
                cast?: {
                    gCastEnabled?: boolean | undefined;
                } | undefined;
            };
        }[];
    } | undefined>;
    getDeletedAfter(target: DateTime): Promise<{
        id: string;
    }[]>;
    getList({ id, withDeleted }?: UserListFilter): Promise<{
        id: string;
        name: string;
        email: string;
        updatedAt: Date;
        createdAt: Date;
        profileImagePath: string;
        isAdmin: boolean;
        shouldChangePassword: boolean;
        avatarColor: import("src/enum").UserAvatarColor | null;
        deletedAt: Date | null;
        oauthId: string;
        storageLabel: string | null;
        quotaSizeInBytes: number | null;
        quotaUsageInBytes: number;
        status: UserStatus;
        profileChangedAt: Date;
        metadata: {
            key: import("src/enum").UserMetadataKey;
            value: {
                isOnboarded: boolean;
            } | {
                licenseKey: string;
                activationKey: string;
                activatedAt: string;
            } | {
                albums?: {
                    defaultAssetOrder?: import("src/enum").AssetOrder | undefined;
                } | undefined;
                folders?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                memories?: {
                    enabled?: boolean | undefined;
                    duration?: number | undefined;
                } | undefined;
                people?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                ratings?: {
                    enabled?: boolean | undefined;
                } | undefined;
                sharedLinks?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                tags?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                emailNotifications?: {
                    enabled?: boolean | undefined;
                    albumInvite?: boolean | undefined;
                    albumUpdate?: boolean | undefined;
                } | undefined;
                download?: {
                    archiveSize?: number | undefined;
                    includeEmbeddedVideos?: boolean | undefined;
                } | undefined;
                purchase?: {
                    showSupportBadge?: boolean | undefined;
                    hideBuyButtonUntil?: string | undefined;
                } | undefined;
                cast?: {
                    gCastEnabled?: boolean | undefined;
                } | undefined;
            };
        }[];
    }[]>;
    create(dto: Insertable<UserTable>): Promise<{
        id: string;
        name: string;
        email: string;
        updatedAt: Date;
        createdAt: Date;
        profileImagePath: string;
        isAdmin: boolean;
        shouldChangePassword: boolean;
        avatarColor: import("src/enum").UserAvatarColor | null;
        deletedAt: Date | null;
        oauthId: string;
        storageLabel: string | null;
        quotaSizeInBytes: number | null;
        quotaUsageInBytes: number;
        status: UserStatus;
        profileChangedAt: Date;
        metadata: {
            key: import("src/enum").UserMetadataKey;
            value: {
                isOnboarded: boolean;
            } | {
                licenseKey: string;
                activationKey: string;
                activatedAt: string;
            } | {
                albums?: {
                    defaultAssetOrder?: import("src/enum").AssetOrder | undefined;
                } | undefined;
                folders?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                memories?: {
                    enabled?: boolean | undefined;
                    duration?: number | undefined;
                } | undefined;
                people?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                ratings?: {
                    enabled?: boolean | undefined;
                } | undefined;
                sharedLinks?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                tags?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                emailNotifications?: {
                    enabled?: boolean | undefined;
                    albumInvite?: boolean | undefined;
                    albumUpdate?: boolean | undefined;
                } | undefined;
                download?: {
                    archiveSize?: number | undefined;
                    includeEmbeddedVideos?: boolean | undefined;
                } | undefined;
                purchase?: {
                    showSupportBadge?: boolean | undefined;
                    hideBuyButtonUntil?: string | undefined;
                } | undefined;
                cast?: {
                    gCastEnabled?: boolean | undefined;
                } | undefined;
            };
        }[];
    }>;
    update(id: string, dto: Updateable<UserTable>): Promise<{
        id: string;
        name: string;
        email: string;
        updatedAt: Date;
        createdAt: Date;
        profileImagePath: string;
        isAdmin: boolean;
        shouldChangePassword: boolean;
        avatarColor: import("src/enum").UserAvatarColor | null;
        deletedAt: Date | null;
        oauthId: string;
        storageLabel: string | null;
        quotaSizeInBytes: number | null;
        quotaUsageInBytes: number;
        status: UserStatus;
        profileChangedAt: Date;
        metadata: {
            key: import("src/enum").UserMetadataKey;
            value: {
                isOnboarded: boolean;
            } | {
                licenseKey: string;
                activationKey: string;
                activatedAt: string;
            } | {
                albums?: {
                    defaultAssetOrder?: import("src/enum").AssetOrder | undefined;
                } | undefined;
                folders?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                memories?: {
                    enabled?: boolean | undefined;
                    duration?: number | undefined;
                } | undefined;
                people?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                ratings?: {
                    enabled?: boolean | undefined;
                } | undefined;
                sharedLinks?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                tags?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                emailNotifications?: {
                    enabled?: boolean | undefined;
                    albumInvite?: boolean | undefined;
                    albumUpdate?: boolean | undefined;
                } | undefined;
                download?: {
                    archiveSize?: number | undefined;
                    includeEmbeddedVideos?: boolean | undefined;
                } | undefined;
                purchase?: {
                    showSupportBadge?: boolean | undefined;
                    hideBuyButtonUntil?: string | undefined;
                } | undefined;
                cast?: {
                    gCastEnabled?: boolean | undefined;
                } | undefined;
            };
        }[];
    }>;
    updateAll(dto: Updateable<UserTable>): Promise<void>;
    restore(id: string): Promise<{
        id: string;
        name: string;
        email: string;
        updatedAt: Date;
        createdAt: Date;
        profileImagePath: string;
        isAdmin: boolean;
        shouldChangePassword: boolean;
        avatarColor: import("src/enum").UserAvatarColor | null;
        deletedAt: Date | null;
        oauthId: string;
        storageLabel: string | null;
        quotaSizeInBytes: number | null;
        quotaUsageInBytes: number;
        status: UserStatus;
        profileChangedAt: Date;
        metadata: {
            key: import("src/enum").UserMetadataKey;
            value: {
                isOnboarded: boolean;
            } | {
                licenseKey: string;
                activationKey: string;
                activatedAt: string;
            } | {
                albums?: {
                    defaultAssetOrder?: import("src/enum").AssetOrder | undefined;
                } | undefined;
                folders?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                memories?: {
                    enabled?: boolean | undefined;
                    duration?: number | undefined;
                } | undefined;
                people?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                ratings?: {
                    enabled?: boolean | undefined;
                } | undefined;
                sharedLinks?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                tags?: {
                    enabled?: boolean | undefined;
                    sidebarWeb?: boolean | undefined;
                } | undefined;
                emailNotifications?: {
                    enabled?: boolean | undefined;
                    albumInvite?: boolean | undefined;
                    albumUpdate?: boolean | undefined;
                } | undefined;
                download?: {
                    archiveSize?: number | undefined;
                    includeEmbeddedVideos?: boolean | undefined;
                } | undefined;
                purchase?: {
                    showSupportBadge?: boolean | undefined;
                    hideBuyButtonUntil?: string | undefined;
                } | undefined;
                cast?: {
                    gCastEnabled?: boolean | undefined;
                } | undefined;
            };
        }[];
    }>;
    upsertMetadata<T extends keyof UserMetadata>(id: string, { key, value }: {
        key: T;
        value: UserMetadata[T];
    }): Promise<void>;
    deleteMetadata<T extends keyof UserMetadata>(id: string, key: T): Promise<void>;
    delete(user: {
        id: string;
    }, hard?: boolean): Promise<import("kysely").UpdateResult[]> | Promise<import("kysely").DeleteResult[]>;
    getUserStats(): Promise<{
        quotaSizeInBytes: number | null;
        userId: string;
        userName: string;
        usage: number;
        photos: number;
        videos: number;
        usagePhotos: number;
        usageVideos: number;
    }[]>;
    getCount(): Promise<number>;
    updateUsage(id: string, delta: number): Promise<void>;
    syncUsage(id?: string): Promise<void>;
}
