import { Kysely } from 'kysely';
import { AssetVisibility } from 'src/enum';
import { DB } from 'src/schema';
export declare class ViewRepository {
    private db;
    constructor(db: Kysely<DB>);
    getUniqueOriginalPaths(userId: string): Promise<string[]>;
    getAssetsByOriginalPath(userId: string, partialPath: string): Promise<{
        id: string;
        type: import("src/enum").AssetType;
        updatedAt: Date;
        updateId: string;
        createdAt: Date;
        deletedAt: Date | null;
        status: import("src/enum").AssetStatus;
        ownerId: string;
        isFavorite: boolean;
        stackId: string | null;
        deviceAssetId: string;
        deviceId: string;
        originalPath: string;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        duration: string | null;
        encodedVideoPath: string | null;
        checksum: Buffer<ArrayBufferLike>;
        livePhotoVideoId: string | null;
        originalFileName: string;
        sidecarPath: string | null;
        thumbhash: Buffer<ArrayBufferLike> | null;
        isOffline: boolean;
        libraryId: string | null;
        isExternal: boolean;
        localDateTime: Date;
        duplicateId: string | null;
        visibility: AssetVisibility;
        exifInfo: import("../database").Exif | null;
    }[]>;
}
