import { OnGatewayConnection, OnGatewayDisconnect, OnGatewayInit } from '@nestjs/websockets';
import { Server, Socket } from 'socket.io';
import { AssetResponseDto } from 'src/dtos/asset-response.dto';
import { AuthDto } from 'src/dtos/auth.dto';
import { NotificationDto } from 'src/dtos/notification.dto';
import { ReleaseNotification, ServerVersionResponseDto } from 'src/dtos/server.dto';
import { SyncAssetExifV1, SyncAssetV1 } from 'src/dtos/sync.dto';
import { AppRestartEvent, ArgsOf, EventRepository } from 'src/repositories/event.repository';
import { LoggingRepository } from 'src/repositories/logging.repository';
export declare const serverEvents: readonly ["ConfigUpdate", "AppRestart"];
export type ServerEvents = (typeof serverEvents)[number];
export interface ClientEventMap {
    on_upload_success: [AssetResponseDto];
    on_user_delete: [string];
    on_asset_delete: [string];
    on_asset_trash: [string[]];
    on_asset_update: [AssetResponseDto];
    on_asset_hidden: [string];
    on_asset_restore: [string[]];
    on_asset_stack_update: string[];
    on_person_thumbnail: [string];
    on_server_version: [ServerVersionResponseDto];
    on_config_update: [];
    on_new_release: [ReleaseNotification];
    on_notification: [NotificationDto];
    on_session_delete: [string];
    AssetUploadReadyV1: [{
        asset: SyncAssetV1;
        exif: SyncAssetExifV1;
    }];
    AppRestartV1: [AppRestartEvent];
}
export type AuthFn = (client: Socket) => Promise<AuthDto>;
export declare class WebsocketRepository implements OnGatewayConnection, OnGatewayDisconnect, OnGatewayInit {
    private eventRepository;
    private logger;
    private authFn?;
    private server?;
    constructor(eventRepository: EventRepository, logger: LoggingRepository);
    afterInit(server: Server): void;
    handleConnection(client: Socket): Promise<void>;
    handleDisconnect(client: Socket): Promise<void>;
    clientSend<T extends keyof ClientEventMap>(event: T, room: string, ...data: ClientEventMap[T]): void;
    clientBroadcast<T extends keyof ClientEventMap>(event: T, ...data: ClientEventMap[T]): void;
    serverSend<T extends ServerEvents>(event: T, ...args: ArgsOf<T>): void;
    setAuthFn(fn: (client: Socket) => Promise<AuthDto>): void;
    private authenticate;
}
