"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkflowRepository = void 0;
const common_1 = require("@nestjs/common");
const kysely_1 = require("kysely");
const nestjs_kysely_1 = require("nestjs-kysely");
const decorators_1 = require("../decorators");
const enum_1 = require("../enum");
let WorkflowRepository = class WorkflowRepository {
    db;
    constructor(db) {
        this.db = db;
    }
    getWorkflow(id) {
        return this.db.selectFrom('workflow').selectAll().where('id', '=', id).executeTakeFirst();
    }
    getWorkflowsByOwner(ownerId) {
        return this.db.selectFrom('workflow').selectAll().where('ownerId', '=', ownerId).orderBy('name').execute();
    }
    getWorkflowsByTrigger(type) {
        return this.db
            .selectFrom('workflow')
            .selectAll()
            .where('triggerType', '=', type)
            .where('enabled', '=', true)
            .execute();
    }
    getWorkflowByOwnerAndTrigger(ownerId, type) {
        return this.db
            .selectFrom('workflow')
            .selectAll()
            .where('ownerId', '=', ownerId)
            .where('triggerType', '=', type)
            .where('enabled', '=', true)
            .execute();
    }
    async createWorkflow(workflow, filters, actions) {
        return await this.db.transaction().execute(async (tx) => {
            const createdWorkflow = await tx.insertInto('workflow').values(workflow).returningAll().executeTakeFirstOrThrow();
            if (filters.length > 0) {
                const newFilters = filters.map((filter) => ({
                    ...filter,
                    workflowId: createdWorkflow.id,
                }));
                await tx.insertInto('workflow_filter').values(newFilters).execute();
            }
            if (actions.length > 0) {
                const newActions = actions.map((action) => ({
                    ...action,
                    workflowId: createdWorkflow.id,
                }));
                await tx.insertInto('workflow_action').values(newActions).execute();
            }
            return createdWorkflow;
        });
    }
    async updateWorkflow(id, workflow, filters, actions) {
        return await this.db.transaction().execute(async (trx) => {
            if (Object.keys(workflow).length > 0) {
                await trx.updateTable('workflow').set(workflow).where('id', '=', id).execute();
            }
            if (filters !== undefined) {
                await trx.deleteFrom('workflow_filter').where('workflowId', '=', id).execute();
                if (filters.length > 0) {
                    const filtersWithWorkflowId = filters.map((filter) => ({
                        ...filter,
                        workflowId: id,
                    }));
                    await trx.insertInto('workflow_filter').values(filtersWithWorkflowId).execute();
                }
            }
            if (actions !== undefined) {
                await trx.deleteFrom('workflow_action').where('workflowId', '=', id).execute();
                if (actions.length > 0) {
                    const actionsWithWorkflowId = actions.map((action) => ({
                        ...action,
                        workflowId: id,
                    }));
                    await trx.insertInto('workflow_action').values(actionsWithWorkflowId).execute();
                }
            }
            return await trx.selectFrom('workflow').selectAll().where('id', '=', id).executeTakeFirstOrThrow();
        });
    }
    async deleteWorkflow(id) {
        await this.db.deleteFrom('workflow').where('id', '=', id).execute();
    }
    getFilters(workflowId) {
        return this.db
            .selectFrom('workflow_filter')
            .selectAll()
            .where('workflowId', '=', workflowId)
            .orderBy('order', 'asc')
            .execute();
    }
    async deleteFiltersByWorkflow(workflowId) {
        await this.db.deleteFrom('workflow_filter').where('workflowId', '=', workflowId).execute();
    }
    getActions(workflowId) {
        return this.db
            .selectFrom('workflow_action')
            .selectAll()
            .where('workflowId', '=', workflowId)
            .orderBy('order', 'asc')
            .execute();
    }
};
exports.WorkflowRepository = WorkflowRepository;
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], WorkflowRepository.prototype, "getWorkflow", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], WorkflowRepository.prototype, "getWorkflowsByOwner", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [enum_1.PluginTriggerType.AssetCreate] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], WorkflowRepository.prototype, "getWorkflowsByTrigger", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, enum_1.PluginTriggerType.AssetCreate] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", void 0)
], WorkflowRepository.prototype, "getWorkflowByOwnerAndTrigger", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], WorkflowRepository.prototype, "deleteWorkflow", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], WorkflowRepository.prototype, "getFilters", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], WorkflowRepository.prototype, "deleteFiltersByWorkflow", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], WorkflowRepository.prototype, "getActions", null);
exports.WorkflowRepository = WorkflowRepository = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, nestjs_kysely_1.InjectKysely)()),
    __metadata("design:paramtypes", [kysely_1.Kysely])
], WorkflowRepository);
//# sourceMappingURL=workflow.repository.js.map