"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.up = up;
exports.down = down;
const kysely_1 = require("kysely");
async function up(db) {
    await (0, kysely_1.sql) `CREATE TABLE "notifications" ("id" uuid NOT NULL DEFAULT uuid_generate_v4(), "createdAt" timestamp with time zone NOT NULL DEFAULT now(), "updatedAt" timestamp with time zone NOT NULL DEFAULT now(), "deletedAt" timestamp with time zone, "updateId" uuid NOT NULL DEFAULT immich_uuid_v7(), "userId" uuid, "level" character varying NOT NULL DEFAULT 'info', "type" character varying NOT NULL DEFAULT 'info', "data" jsonb, "title" character varying NOT NULL, "description" text, "readAt" timestamp with time zone);`.execute(db);
    await (0, kysely_1.sql) `ALTER TABLE "notifications" ADD CONSTRAINT "PK_6a72c3c0f683f6462415e653c3a" PRIMARY KEY ("id");`.execute(db);
    await (0, kysely_1.sql) `ALTER TABLE "notifications" ADD CONSTRAINT "FK_692a909ee0fa9383e7859f9b406" FOREIGN KEY ("userId") REFERENCES "users" ("id") ON UPDATE CASCADE ON DELETE CASCADE;`.execute(db);
    await (0, kysely_1.sql) `CREATE INDEX "IDX_notifications_update_id" ON "notifications" ("updateId")`.execute(db);
    await (0, kysely_1.sql) `CREATE INDEX "IDX_692a909ee0fa9383e7859f9b40" ON "notifications" ("userId")`.execute(db);
    await (0, kysely_1.sql) `CREATE OR REPLACE TRIGGER "notifications_updated_at"
  BEFORE UPDATE ON "notifications"
  FOR EACH ROW
  EXECUTE FUNCTION updated_at();`.execute(db);
}
async function down(db) {
    await (0, kysely_1.sql) `DROP TRIGGER "notifications_updated_at" ON "notifications";`.execute(db);
    await (0, kysely_1.sql) `DROP INDEX "IDX_notifications_update_id";`.execute(db);
    await (0, kysely_1.sql) `DROP INDEX "IDX_692a909ee0fa9383e7859f9b40";`.execute(db);
    await (0, kysely_1.sql) `ALTER TABLE "notifications" DROP CONSTRAINT "PK_6a72c3c0f683f6462415e653c3a";`.execute(db);
    await (0, kysely_1.sql) `ALTER TABLE "notifications" DROP CONSTRAINT "FK_692a909ee0fa9383e7859f9b406";`.execute(db);
    await (0, kysely_1.sql) `DROP TABLE "notifications";`.execute(db);
}
//# sourceMappingURL=1744991379464-AddNotificationsTable.js.map