"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.up = up;
exports.down = down;
const kysely_1 = require("kysely");
async function up(db) {
    await (0, kysely_1.sql) `CREATE OR REPLACE FUNCTION album_assets_delete_audit()
  RETURNS TRIGGER
  LANGUAGE PLPGSQL
  AS $$
    BEGIN
      INSERT INTO album_assets_audit ("albumId", "assetId")
      SELECT "albumsId", "assetsId" FROM OLD
      WHERE "albumsId" IN (SELECT "id" FROM albums WHERE "id" IN (SELECT "albumsId" FROM OLD));
      RETURN NULL;
    END
  $$;`.execute(db);
    await (0, kysely_1.sql) `ALTER TABLE "album_assets_audit" ADD CONSTRAINT "FK_8047b44b812619a3c75a2839b0d" FOREIGN KEY ("albumId") REFERENCES "albums" ("id") ON UPDATE CASCADE ON DELETE CASCADE;`.execute(db);
    await (0, kysely_1.sql) `CREATE OR REPLACE TRIGGER "album_assets_delete_audit"
  AFTER DELETE ON "albums_assets_assets"
  REFERENCING OLD TABLE AS "old"
  FOR EACH STATEMENT
  WHEN (pg_trigger_depth() <= 1)
  EXECUTE FUNCTION album_assets_delete_audit();`.execute(db);
}
async function down(db) {
    await (0, kysely_1.sql) `DROP TRIGGER "album_assets_delete_audit" ON "albums_assets_assets";`.execute(db);
    await (0, kysely_1.sql) `ALTER TABLE "album_assets_audit" DROP CONSTRAINT "FK_8047b44b812619a3c75a2839b0d";`.execute(db);
    await (0, kysely_1.sql) `DROP FUNCTION album_assets_delete_audit;`.execute(db);
}
//# sourceMappingURL=1750780093818-AddAlbumToAssetDeleteTrigger.js.map