import { BulkIdsDto } from 'src/dtos/asset-ids.response.dto';
import { AuthDto } from 'src/dtos/auth.dto';
import { DuplicateResponseDto } from 'src/dtos/duplicate.dto';
import { JobName, JobStatus } from 'src/enum';
import { BaseService } from 'src/services/base.service';
import { JobOf } from 'src/types';
export declare class DuplicateService extends BaseService {
    getDuplicates(auth: AuthDto): Promise<DuplicateResponseDto[]>;
    delete(auth: AuthDto, id: string): Promise<void>;
    deleteAll(auth: AuthDto, dto: BulkIdsDto): Promise<void>;
    handleQueueSearchDuplicates({ force }: JobOf<JobName.AssetDetectDuplicatesQueueAll>): Promise<JobStatus>;
    handleSearchDuplicates({ id }: JobOf<JobName.AssetDetectDuplicates>): Promise<JobStatus>;
    private updateDuplicates;
}
