import { CreateLibraryDto, LibraryResponseDto, LibraryStatsResponseDto, UpdateLibraryDto, ValidateLibraryDto, ValidateLibraryResponseDto } from 'src/dtos/library.dto';
import { JobName, JobStatus } from 'src/enum';
import { ArgOf } from 'src/repositories/event.repository';
import { BaseService } from 'src/services/base.service';
import { JobOf } from 'src/types';
export declare class LibraryService extends BaseService {
    private watchLibraries;
    private lock;
    private watchers;
    onConfigInit({ newConfig: { library: { watch, scan }, }, }: ArgOf<'ConfigInit'>): Promise<void>;
    onConfigUpdate({ newConfig: { library } }: ArgOf<'ConfigUpdate'>): Promise<void>;
    private watch;
    unwatch(id: string): Promise<void>;
    onShutdown(): Promise<void>;
    private unwatchAll;
    watchAll(): Promise<false | undefined>;
    getStatistics(id: string): Promise<LibraryStatsResponseDto>;
    get(id: string): Promise<LibraryResponseDto>;
    getAll(): Promise<LibraryResponseDto[]>;
    handleQueueCleanup(): Promise<JobStatus>;
    create(dto: CreateLibraryDto): Promise<LibraryResponseDto>;
    handleSyncFiles(job: JobOf<JobName.LibrarySyncFiles>): Promise<JobStatus>;
    private validateImportPath;
    validate(id: string, dto: ValidateLibraryDto): Promise<ValidateLibraryResponseDto>;
    update(id: string, dto: UpdateLibraryDto): Promise<LibraryResponseDto>;
    delete(id: string): Promise<void>;
    handleDeleteLibrary(job: JobOf<JobName.LibraryDelete>): Promise<JobStatus>;
    private processEntity;
    queuePostSyncJobs(assetIds: string[]): Promise<void>;
    queueScan(id: string): Promise<void>;
    queueScanAll(): Promise<void>;
    handleQueueScanAll(): Promise<JobStatus>;
    handleSyncAssets(job: JobOf<JobName.LibrarySyncAssets>): Promise<JobStatus>;
    private checkExistingAsset;
    handleQueueSyncFiles(job: JobOf<JobName.LibrarySyncFilesQueueAll>): Promise<JobStatus>;
    handleAssetRemoval(job: JobOf<JobName.LibraryRemoveAsset>): Promise<JobStatus>;
    handleQueueSyncAssets(job: JobOf<JobName.LibrarySyncAssetsQueueAll>): Promise<JobStatus>;
    private findOrFail;
}
