import { ClassConstructor } from 'class-transformer';
import { QueueCommandDto, QueueResponseDto, QueuesResponseDto } from 'src/dtos/queue.dto';
import { QueueName } from 'src/enum';
import { ArgOf } from 'src/repositories/event.repository';
import { BaseService } from 'src/services/base.service';
export declare class QueueService extends BaseService {
    private services;
    private nightlyJobsLock;
    onConfigInit({ newConfig: config }: ArgOf<'ConfigInit'>): Promise<void>;
    onConfigUpdate({ newConfig: config }: ArgOf<'ConfigUpdate'>): void;
    onBootstrap(): void;
    private updateConcurrency;
    setServices(services: ClassConstructor<unknown>[]): void;
    runCommand(name: QueueName, dto: QueueCommandDto): Promise<QueueResponseDto>;
    getAll(): Promise<QueuesResponseDto>;
    getByName(name: QueueName): Promise<QueueResponseDto>;
    private start;
    private isConcurrentQueue;
    handleNightlyJobs(): Promise<void>;
}
