import { LicenseKeyDto, LicenseResponseDto } from 'src/dtos/license.dto';
import { ServerAboutResponseDto, ServerApkLinksDto, ServerConfigDto, ServerFeaturesDto, ServerMediaTypesResponseDto, ServerPingResponse, ServerStatsResponseDto, ServerStorageResponseDto } from 'src/dtos/server.dto';
import { BaseService } from 'src/services/base.service';
export declare class ServerService extends BaseService {
    onBootstrap(): Promise<void>;
    getAboutInfo(): Promise<ServerAboutResponseDto>;
    getApkLinks(): ServerApkLinksDto;
    getStorage(): Promise<ServerStorageResponseDto>;
    ping(): ServerPingResponse;
    getFeatures(): Promise<ServerFeaturesDto>;
    getTheme(): Promise<{
        customCss: string;
    }>;
    getSystemConfig(): Promise<ServerConfigDto>;
    getStatistics(): Promise<ServerStatsResponseDto>;
    getSupportedMediaTypes(): ServerMediaTypesResponseDto;
    deleteLicense(): Promise<void>;
    getLicense(): Promise<LicenseResponseDto>;
    setLicense(dto: LicenseKeyDto): Promise<LicenseResponseDto>;
}
