import { SystemConfigTemplateStorageOptionDto } from 'src/dtos/system-config.dto';
import { JobName, JobStatus } from 'src/enum';
import { ArgOf } from 'src/repositories/event.repository';
import { BaseService } from 'src/services/base.service';
import { JobOf, StorageAsset } from 'src/types';
export interface MoveAssetMetadata {
    storageLabel: string | null;
    filename: string;
}
export declare class StorageTemplateService extends BaseService {
    private _template;
    private get template();
    onConfigInit({ newConfig }: ArgOf<'ConfigInit'>): void;
    onConfigUpdate({ newConfig }: ArgOf<'ConfigUpdate'>): void;
    onConfigValidate({ newConfig }: ArgOf<'ConfigValidate'>): void;
    getStorageTemplateOptions(): SystemConfigTemplateStorageOptionDto;
    onAssetMetadataExtracted({ source, assetId }: ArgOf<'AssetMetadataExtracted'>): Promise<void>;
    handleMigrationSingle({ id }: JobOf<JobName.StorageTemplateMigrationSingle>): Promise<JobStatus>;
    handleMigration(): Promise<JobStatus>;
    handleMoveHistoryCleanup({ assetId }: ArgOf<'AssetDelete'>): Promise<void>;
    moveAsset(asset: StorageAsset, metadata: MoveAssetMetadata): Promise<void>;
    private getTemplatePath;
    private compile;
    private render;
}
