import { SystemConfigDto } from 'src/dtos/system-config.dto';
import { ArgOf } from 'src/repositories/event.repository';
import { BaseService } from 'src/services/base.service';
export declare class SystemConfigService extends BaseService {
    onBootstrap(): Promise<void>;
    onShutdown(): void;
    getSystemConfig(): Promise<SystemConfigDto>;
    getDefaults(): SystemConfigDto;
    onConfigInit({ newConfig: { logging, machineLearning } }: ArgOf<'ConfigInit'>): void;
    onConfigUpdate({ newConfig }: ArgOf<'ConfigUpdate'>): void;
    onConfigValidate({ newConfig, oldConfig }: ArgOf<'ConfigValidate'>): void;
    updateSystemConfig(dto: SystemConfigDto): Promise<SystemConfigDto>;
    getCustomCss(): Promise<string>;
}
