"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.compareFunctions = void 0;
const types_1 = require("../types");
exports.compareFunctions = {
    onMissing: (source) => [
        {
            type: 'FunctionCreate',
            function: source,
            reason: types_1.Reason.MissingInTarget,
        },
    ],
    onExtra: (target) => [
        {
            type: 'FunctionDrop',
            functionName: target.name,
            reason: types_1.Reason.MissingInSource,
        },
    ],
    onCompare: (source, target) => {
        if (source.expression !== target.expression) {
            const reason = `function expression has changed (${source.expression} vs ${target.expression})`;
            return [
                {
                    type: 'FunctionCreate',
                    function: source,
                    reason,
                },
            ];
        }
        return [];
    },
};
//# sourceMappingURL=function.comparer.js.map