"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.compareOverrides = void 0;
const types_1 = require("../types");
exports.compareOverrides = {
    onMissing: (source) => [
        {
            type: 'OverrideCreate',
            override: source,
            reason: types_1.Reason.MissingInTarget,
        },
    ],
    onExtra: (target) => [
        {
            type: 'OverrideDrop',
            overrideName: target.name,
            reason: types_1.Reason.MissingInSource,
        },
    ],
    onCompare: (source, target) => {
        if (source.value.name !== target.value.name || source.value.sql !== target.value.sql) {
            const sourceValue = JSON.stringify(source.value);
            const targetValue = JSON.stringify(target.value);
            return [
                { type: 'OverrideUpdate', override: source, reason: `value is different (${sourceValue} vs ${targetValue})` },
            ];
        }
        return [];
    },
};
//# sourceMappingURL=override.comparer.js.map