"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.schemaFromDatabase = void 0;
const kysely_1 = require("kysely");
const kysely_postgres_js_1 = require("kysely-postgres-js");
const reader_context_1 = require("./contexts/reader-context");
const readers_1 = require("./readers");
const schemaFromDatabase = async (postgres, options = {}) => {
    const db = new kysely_1.Kysely({ dialect: new kysely_postgres_js_1.PostgresJSDialect({ postgres }) });
    const ctx = new reader_context_1.ReaderContext(options);
    try {
        for (const reader of readers_1.readers) {
            await reader(ctx, db);
        }
        return ctx.build();
    }
    finally {
        await db.destroy();
    }
};
exports.schemaFromDatabase = schemaFromDatabase;
//# sourceMappingURL=schema-from-database.js.map