import { SystemConfig } from 'src/config';
import { ConfigRepository } from 'src/repositories/config.repository';
import { LoggingRepository } from 'src/repositories/logging.repository';
import { SystemMetadataRepository } from 'src/repositories/system-metadata.repository';
export type SystemConfigValidator = (config: SystemConfig, newConfig: SystemConfig) => void | Promise<void>;
type RepoDeps = {
    configRepo: ConfigRepository;
    metadataRepo: SystemMetadataRepository;
    logger: LoggingRepository;
};
export declare const clearConfigCache: () => void;
export declare const getConfig: (repos: RepoDeps, { withCache }: {
    withCache: boolean;
}) => Promise<SystemConfig>;
export declare const updateConfig: (repos: RepoDeps, newConfig: SystemConfig) => Promise<SystemConfig>;
export {};
