"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@nestjs/core");
const app_common_1 = require("../app.common");
const app_module_1 = require("../app.module");
const maintenance_worker_service_1 = require("../maintenance/maintenance-worker.service");
const app_repository_1 = require("../repositories/app.repository");
const misc_1 = require("../utils/misc");
async function bootstrap() {
    process.title = 'immich-maintenance';
    (0, app_common_1.configureTelemetry)();
    const app = await core_1.NestFactory.create(app_module_1.MaintenanceModule, { bufferLogs: true });
    app.get(app_repository_1.AppRepository).setCloseFn(() => app.close());
    void (0, app_common_1.configureExpress)(app, {
        permitSwaggerWrite: false,
        ssr: maintenance_worker_service_1.MaintenanceWorkerService,
    });
    void app.get(maintenance_worker_service_1.MaintenanceWorkerService).logSecret();
}
bootstrap().catch((error) => {
    if (!(0, misc_1.isStartUpError)(error)) {
        console.error(error);
    }
    process.exit(1);
});
//# sourceMappingURL=maintenance.js.map