"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.bootstrap = bootstrap;
const core_1 = require("@nestjs/core");
const node_worker_threads_1 = require("node:worker_threads");
const app_module_1 = require("../app.module");
const constants_1 = require("../constants");
const websocket_adapter_1 = require("../middleware/websocket.adapter");
const app_repository_1 = require("../repositories/app.repository");
const config_repository_1 = require("../repositories/config.repository");
const logging_repository_1 = require("../repositories/logging.repository");
const telemetry_repository_1 = require("../repositories/telemetry.repository");
const misc_1 = require("../utils/misc");
async function bootstrap() {
    const { telemetry } = new config_repository_1.ConfigRepository().getEnv();
    if (telemetry.metrics.size > 0) {
        (0, telemetry_repository_1.bootstrapTelemetry)(telemetry.microservicesPort);
    }
    const app = await core_1.NestFactory.create(app_module_1.MicroservicesModule, { bufferLogs: true });
    const logger = await app.resolve(logging_repository_1.LoggingRepository);
    const configRepository = app.get(config_repository_1.ConfigRepository);
    app.get(app_repository_1.AppRepository).setCloseFn(() => app.close());
    const { environment, host } = configRepository.getEnv();
    logger.setContext('Bootstrap');
    app.useLogger(logger);
    app.useWebSocketAdapter(new websocket_adapter_1.WebSocketAdapter(app));
    await (host ? app.listen(0, host) : app.listen(0));
    logger.log(`Immich Microservices is running [v${constants_1.serverVersion}] [${environment}] `);
}
if (!node_worker_threads_1.isMainThread) {
    bootstrap().catch((error) => {
        if (!(0, misc_1.isStartUpError)(error)) {
            console.error(error);
        }
        throw error;
    });
}
//# sourceMappingURL=microservices.js.map