import { CallContext } from './call-context.ts';
import { type InternalConfig, InternalWasi, PluginOutput } from './interfaces.ts';
export declare const EXTISM_ENV = "extism:host/env";
type InstantiatedModule = [WebAssembly.Module, WebAssembly.Instance];
export declare class ForegroundPlugin {
    #private;
    constructor(opts: InternalConfig, context: CallContext, instancePair: InstantiatedModule, wasi: InternalWasi[], suspendsOnInvoke: boolean);
    reset(): Promise<boolean>;
    isActive(): boolean;
    functionExists(funcName: string): Promise<boolean>;
    callBlock(funcName: string, input: number | null): Promise<[number | null, number | null]>;
    call<T = any>(funcName: string, input?: string | Uint8Array, hostContext?: T): Promise<PluginOutput | null>;
    getExports(): Promise<WebAssembly.ModuleExportDescriptor[]>;
    getImports(): Promise<WebAssembly.ModuleImportDescriptor[]>;
    getInstance(): Promise<WebAssembly.Instance>;
    close(): Promise<void>;
}
export declare function createForegroundPlugin(opts: InternalConfig, names: string[], modules: WebAssembly.Module[], context?: CallContext): Promise<ForegroundPlugin>;
export {};
