"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var index_exports = {};
__export(index_exports, {
  Button: () => Button
});
module.exports = __toCommonJS(index_exports);

// src/button.tsx
var React = __toESM(require("react"));

// src/utils/parse-padding.ts
function convertToPx(value) {
  let px = 0;
  if (!value) {
    return px;
  }
  if (typeof value === "number") {
    return value;
  }
  const matches = /^([\d.]+)(px|em|rem|%)$/.exec(value);
  if (matches && matches.length === 3) {
    const numValue = Number.parseFloat(matches[1]);
    const unit = matches[2];
    switch (unit) {
      case "px":
        return numValue;
      case "em":
      case "rem":
        px = numValue * 16;
        return px;
      case "%":
        px = numValue / 100 * 600;
        return px;
      default:
        return numValue;
    }
  }
  return 0;
}
function parsePaddingValue(value) {
  if (typeof value === "number")
    return {
      paddingTop: value,
      paddingBottom: value,
      paddingLeft: value,
      paddingRight: value
    };
  if (typeof value === "string") {
    const values = value.toString().trim().split(/\s+/);
    if (values.length === 1) {
      return {
        paddingTop: values[0],
        paddingBottom: values[0],
        paddingLeft: values[0],
        paddingRight: values[0]
      };
    }
    if (values.length === 2) {
      return {
        paddingTop: values[0],
        paddingRight: values[1],
        paddingBottom: values[0],
        paddingLeft: values[1]
      };
    }
    if (values.length === 3) {
      return {
        paddingTop: values[0],
        paddingRight: values[1],
        paddingBottom: values[2],
        paddingLeft: values[1]
      };
    }
    if (values.length === 4) {
      return {
        paddingTop: values[0],
        paddingRight: values[1],
        paddingBottom: values[2],
        paddingLeft: values[3]
      };
    }
  }
  return {
    paddingTop: void 0,
    paddingBottom: void 0,
    paddingLeft: void 0,
    paddingRight: void 0
  };
}
function parsePadding(properties) {
  let paddingTop;
  let paddingRight;
  let paddingBottom;
  let paddingLeft;
  for (const [key, value] of Object.entries(properties)) {
    if (key === "padding") {
      ({ paddingTop, paddingBottom, paddingLeft, paddingRight } = parsePaddingValue(value));
    } else if (key === "paddingTop") {
      paddingTop = value;
    } else if (key === "paddingRight") {
      paddingRight = value;
    } else if (key === "paddingBottom") {
      paddingBottom = value;
    } else if (key === "paddingLeft") {
      paddingLeft = value;
    }
  }
  return {
    paddingTop: paddingTop ? convertToPx(paddingTop) : void 0,
    paddingRight: paddingRight ? convertToPx(paddingRight) : void 0,
    paddingBottom: paddingBottom ? convertToPx(paddingBottom) : void 0,
    paddingLeft: paddingLeft ? convertToPx(paddingLeft) : void 0
  };
}

// src/utils/px-to-pt.ts
var pxToPt = (px) => typeof px === "number" && !Number.isNaN(Number(px)) ? px * 3 / 4 : void 0;

// src/button.tsx
var import_jsx_runtime = require("react/jsx-runtime");
var maxFontWidth = 5;
function computeFontWidthAndSpaceCount(expectedWidth) {
  if (expectedWidth === 0) return [0, 0];
  let smallestSpaceCount = 0;
  const computeRequiredFontWidth = () => {
    if (smallestSpaceCount > 0) {
      return expectedWidth / smallestSpaceCount / 2;
    }
    return Number.POSITIVE_INFINITY;
  };
  while (computeRequiredFontWidth() > maxFontWidth) {
    smallestSpaceCount++;
  }
  return [computeRequiredFontWidth(), smallestSpaceCount];
}
var Button = React.forwardRef(
  (_a, ref) => {
    var _b = _a, { children, style, target = "_blank" } = _b, props = __objRest(_b, ["children", "style", "target"]);
    const { paddingTop, paddingRight, paddingBottom, paddingLeft } = parsePadding(style != null ? style : {});
    const y = (paddingTop != null ? paddingTop : 0) + (paddingBottom != null ? paddingBottom : 0);
    const textRaise = pxToPt(y);
    const [plFontWidth, plSpaceCount] = computeFontWidthAndSpaceCount(
      paddingLeft != null ? paddingLeft : 0
    );
    const [prFontWidth, prSpaceCount] = computeFontWidthAndSpaceCount(
      paddingRight != null ? paddingRight : 0
    );
    return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(
      "a",
      __spreadProps(__spreadValues({}, props), {
        ref,
        style: __spreadProps(__spreadValues({
          lineHeight: "100%",
          textDecoration: "none",
          display: "inline-block",
          maxWidth: "100%",
          msoPaddingAlt: "0px"
        }, style), {
          paddingTop,
          paddingRight,
          paddingBottom,
          paddingLeft
        }),
        target,
        children: [
          /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
            "span",
            {
              dangerouslySetInnerHTML: {
                // The `&#8202;` is as close to `1px` of an empty character as we can get, then, we use the `mso-font-width`
                // to scale it according to what padding the developer wants. `mso-font-width` also does not allow for percentages
                // >= 500% so we need to add extra spaces accordingly.
                //
                // See https://github.com/resend/react-email/issues/1512 for why we do not use letter-spacing instead.
                __html: `<!--[if mso]><i style="mso-font-width:${plFontWidth * 100}%;mso-text-raise:${textRaise}" hidden>${"&#8202;".repeat(
                  plSpaceCount
                )}</i><![endif]-->`
              }
            }
          ),
          /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
            "span",
            {
              style: {
                maxWidth: "100%",
                display: "inline-block",
                lineHeight: "120%",
                msoPaddingAlt: "0px",
                msoTextRaise: pxToPt(paddingBottom)
              },
              children
            }
          ),
          /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
            "span",
            {
              dangerouslySetInnerHTML: {
                __html: `<!--[if mso]><i style="mso-font-width:${prFontWidth * 100}%" hidden>${"&#8202;".repeat(
                  prSpaceCount
                )}&#8203;</i><![endif]-->`
              }
            }
          )
        ]
      })
    );
  }
);
Button.displayName = "Button";
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  Button
});
