import { BatchClusterEmitter, ChildEndReason } from "./BatchClusterEmitter";
import { Logger } from "./Logger";
/**
 * Configuration for event handling behavior
 */
export interface EventCoordinatorOptions {
    readonly streamFlushMillis: number;
    readonly maxReasonableProcessFailuresPerMinute: number;
    readonly logger: () => Logger;
}
/**
 * Centralized coordinator for BatchCluster events.
 * Handles event processing, statistics tracking, and automated responses to events.
 */
export declare class BatchClusterEventCoordinator {
    #private;
    private readonly emitter;
    private readonly options;
    private readonly onIdleLater;
    private readonly endCluster;
    constructor(emitter: BatchClusterEmitter, options: EventCoordinatorOptions, onIdleLater: () => void, endCluster: () => void);
    /**
     * Get the mean number of tasks completed by child processes
     */
    get meanTasksPerProc(): number;
    /**
     * Get internal error count
     */
    get internalErrorCount(): number;
    /**
     * Get start error rate per minute
     */
    get startErrorRatePerMinute(): number;
    /**
     * Get count of ended child processes by reason
     */
    countEndedChildProcs(reason: ChildEndReason): number;
    /**
     * Get all child end counts
     */
    get childEndCounts(): Record<NonNullable<ChildEndReason>, number>;
    /**
     * Get event statistics for monitoring
     */
    getEventStats(): {
        meanTasksPerProc: number;
        internalErrorCount: number;
        startErrorRatePerMinute: number;
        totalChildEndEvents: number;
        childEndReasons: string[];
    };
    /**
     * Reset event statistics (useful for testing)
     */
    resetStats(): void;
    /**
     * Get the underlying emitter for direct event access
     */
    get events(): BatchClusterEmitter;
}
