/**
 * Aggregate promises efficiently
 */
export declare class Mutex {
    private _pushCount;
    private readonly _arr;
    private get arr();
    get pushCount(): number;
    push<T>(f: () => Promise<T>): Promise<T>;
    /**
     * Run f() after all prior-enqueued promises have resolved.
     */
    serial<T>(f: () => Promise<T>): Promise<T>;
    /**
     * Only run f() if all prior have finished, otherwise, no-op and wait until
     * all pending have resolved.
     */
    runIfIdle<T>(f: () => Promise<T>): undefined | Promise<T>;
    get pendingCount(): number;
    get pending(): boolean;
    get settled(): boolean;
    /**
     * @return a promise that will be resolved when all previously-pushed Promises
     * are resolved. Any promise rejection will throw the whole chain.
     */
    awaitAll(): Promise<undefined>;
}
