"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.destroy = destroy;
function destroy(stream) {
    var _a;
    try {
        // .end() may result in an EPIPE when the child process exits. We don't
        // care. We just want to make sure the stream is closed.
        stream === null || stream === void 0 ? void 0 : stream.removeAllListeners("error");
        // It's fine to call .destroy() on a stream that's already destroyed.
        (_a = stream === null || stream === void 0 ? void 0 : stream.destroy) === null || _a === void 0 ? void 0 : _a.call(stream);
    }
    catch {
        // don't care
    }
}
//# sourceMappingURL=Stream.js.map