import { JobSchedulerJson, RepeatBaseOptions, RepeatOptions } from '../interfaces';
import { JobSchedulerTemplateOptions } from '../types';
import { Job } from './job';
import { QueueBase } from './queue-base';
import { RedisConnection } from './redis-connection';
export declare class JobScheduler extends QueueBase {
    private repeatStrategy;
    constructor(name: string, opts: RepeatBaseOptions, Connection?: typeof RedisConnection);
    upsertJobScheduler<T = any, R = any, N extends string = string>(jobSchedulerId: string, repeatOpts: Omit<RepeatOptions, 'key' | 'prevMillis'>, jobName: N, jobData: T, opts: JobSchedulerTemplateOptions, { override, producerId }: {
        override: boolean;
        producerId?: string;
    }): Promise<Job<T, R, N> | undefined>;
    private getNextJobOpts;
    removeJobScheduler(jobSchedulerId: string): Promise<number>;
    private getSchedulerData;
    private transformSchedulerData;
    private keyToData;
    getScheduler<D = any>(id: string): Promise<JobSchedulerJson<D> | undefined>;
    private getTemplateFromJSON;
    getJobSchedulers<D = any>(start?: number, end?: number, asc?: boolean): Promise<JobSchedulerJson<D>[]>;
    getSchedulersCount(): Promise<number>;
    private getSchedulerNextJobId;
}
export declare const defaultRepeatStrategy: (millis: number, opts: RepeatOptions) => number | undefined;
