import { ExifToolOptions } from "./ExifToolOptions";
import { ExifToolTask } from "./ExifToolTask";
import { Maybe } from "./Maybe";
export type BinaryExtractionTaskOptions = Pick<ExifToolOptions, "ignoreMinorErrors"> & Partial<Pick<ExifToolOptions, "forceWrite">>;
/**
 * Task that returns an error string (to prevent retries), or undefined if
 * everything seems to have worked.
 */
export declare class BinaryExtractionTask extends ExifToolTask<Maybe<string>> {
    private constructor();
    static for(tagname: string, imgSrc: string, imgDest: string, options?: BinaryExtractionTaskOptions): BinaryExtractionTask;
    parse(stdout: string, err?: Error): Maybe<string>;
}
