"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toBoolean = toBoolean;
const Truthy = ["true", "yes", "1", "on"];
const Falsy = ["false", "no", "0", "off"];
function toBoolean(value) {
    if (value == null)
        return undefined;
    if (typeof value === "boolean")
        return value;
    const s = String(value).trim().toLowerCase();
    return Truthy.includes(s) ? true : Falsy.includes(s) ? false : undefined;
}
//# sourceMappingURL=Boolean.js.map