"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isPlatformCaseSensitive = void 0;
exports.isFileEmpty = isFileEmpty;
exports.compareFilePaths = compareFilePaths;
const node_fs_1 = require("node:fs");
const node_path_1 = require("node:path");
const Lazy_1 = require("./Lazy");
const String_1 = require("./String");
async function isFileEmpty(path) {
    if ((0, String_1.blank)(path)) {
        throw new Error("isFileEmpty(): blank path");
    }
    // TODO: convert this to using fs/promises once node 12 is EOL (2022-04-30)
    try {
        const s = await new Promise((res, rej) => {
            try {
                (0, node_fs_1.stat)(path, (err, val) => (err == null ? res(val) : rej(err)));
            }
            catch (err) {
                rej(err);
            }
        });
        return s == null || s.size === 0;
    }
    catch (err) {
        if (err &&
            typeof err === "object" &&
            "code" in err &&
            err.code === "ENOENT")
            return true;
        else
            throw err;
    }
}
exports.isPlatformCaseSensitive = (0, Lazy_1.lazy)(() => process.platform !== "win32" && process.platform !== "darwin");
function compareFilePaths(a, b) {
    const aNorm = (0, node_path_1.normalize)(a);
    const bNorm = (0, node_path_1.normalize)(b);
    return (0, exports.isPlatformCaseSensitive)()
        ? aNorm === bNorm
        : aNorm.localeCompare(bNorm, undefined, { sensitivity: "base" }) === 0;
}
//# sourceMappingURL=File.js.map