import { Maybe } from "./Maybe";
export interface IgnorableError {
    (err: Maybe<Error | string>): boolean;
}
/**
 * This is the default implementation of IgnorableError, and ignores null,
 * undefined, errors without a message, warnings about duplicate tags, and
 * ICC_Profile deletions.
 */
export declare function isWarning(err: Maybe<Error | string>): boolean;
