"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TagNames = exports.XMPTagsNames = exports.MakerNotesTagsNames = exports.JFIFTagsNames = exports.RIFFTagsNames = exports.RAFTagsNames = exports.QuickTimeTagsNames = exports.IPTCTagsNames = exports.PrintIMTagsNames = exports.PhotoshopTagsNames = exports.PanasonicRawTagsNames = exports.MetaTagsNames = exports.MPFTagsNames = exports.JUMBFTagsNames = exports.JSONTagsNames = exports.JPEGTagsNames = exports.EXIFTagsNames = exports.FlashPixTagsNames = exports.DuckyTagsNames = exports.APPTagsNames = exports.CompositeTagsNames = exports.FileTagsNames = exports.ExifToolTagsNames = void 0;
const ExifToolVendoredTags_1 = require("./ExifToolVendoredTags");
const GeolocationTags_1 = require("./GeolocationTags");
const ICCProfileTags_1 = require("./ICCProfileTags");
const ImageDataHashTag_1 = require("./ImageDataHashTag");
const IPTCApplicationRecordTags_1 = require("./IPTCApplicationRecordTags");
const MWGTags_1 = require("./MWGTags");
const StrEnum_1 = require("./StrEnum");
exports.ExifToolTagsNames = (0, StrEnum_1.strEnum)("Error", "ExifToolVersion", "SourceFile", "Warning");
exports.FileTagsNames = (0, StrEnum_1.strEnum)("BitDepth", "BitsPerSample", "BMPVersion", "ColorComponents", "Comment", "Compression", "CurrentIPTCDigest", "Directory", "EncodingProcess", "ExifByteOrder", "FileAccessDate", "FileCreateDate", "FileInodeChangeDate", "FileModifyDate", "FileName", "FilePermissions", "FileSize", "FileType", "FileTypeExtension", "ImageDataMD5", "ImageHeight", "ImageLength", "ImageWidth", "MakerNoteByteOrder", "MIMEType", "NumColors", "NumImportantColors", "PixelsPerMeterX", "PixelsPerMeterY", "Planes", "PreviewImage", "YCbCrSubSampling");
exports.CompositeTagsNames = (0, StrEnum_1.strEnum)("AdvancedSceneMode", "Aperture", "AutoFocus", "AvgBitrate", "BlueBalance", "CFAPattern", "CircleOfConfusion", "ConditionalFEC", "ContrastDetectAF", "DateCreated", "DateTimeCreated", "DateTimeOriginal", "DigitalCreationDateTime", "DigitalZoom", "DOF", "DriveMode", "Duration", "ExtenderStatus", "FileNumber", "FlashType", "FocusDistance", "FOV", "GPSAltitude", "GPSAltitudeRef", "GPSDateTime", "GPSDestLatitude", "GPSDestLongitude", "GPSLatitude", "GPSLatitudeRef", "GPSLongitude", "GPSLongitudeRef", "GPSPosition", "HyperfocalDistance", "ImageHeight", "ImageSize", "ImageWidth", "ISO", "Lens", "Lens35efl", "LensID", "LensSpec", "LensType", "Megapixels", "OriginalDecisionData", "PeakSpectralSensitivity", "PhaseDetectAF", "PreviewImage", "RedBalance", "RedEyeReduction", "RicohPitch", "RicohRoll", "Rotation", "RunTimeSincePowerUp", "ScaleFactor35efl", "ShootingMode", "ShutterCurtainHack", "ShutterSpeed", "SubSecCreateDate", "SubSecDateTimeOriginal", "SubSecMediaCreateDate", "SubSecModifyDate");
exports.APPTagsNames = (0, StrEnum_1.strEnum)("AboveColor", "Again", "AmbientTemperature", "Aperture", "AtmosphericTemperature", "AutoISOMax", "AutoISOMin", "AutoRotation", "B5100", "Balance", "Barcode", "BelowColor", "Bgain", "BHighLight", "BHL", "BitsPerSample", "Blk0", "Blk1", "BMean", "Boff", "BSD", "BSd", "BStrobe", "CameraModel", "CameraPartNumber", "CameraSerialNumber", "CameraSoftware", "CameraType", "Case", "Category", "CBal", "Color", "COLOR1", "COLOR2", "COLOR3", "COLOR4", "ColorComponents", "ColorMode", "ColorSpace", "ColorTransform", "Compass", "Compression", "ContTake", "CreatorSoftware", "DateTimeGenerated", "DateTimeOriginal", "DCTEncodeVersion", "DeviceName", "DiagonalFieldOfView", "DigitalZoom", "DigitalZoomOn", "EmbeddedImage", "EmbeddedImageHeight", "EmbeddedImageType", "EmbeddedImageWidth", "Emissivity", "EXP1", "EXP2", "EXP3", "ExposRatio", "Exposure", "ExposureCompensation", "ExposureTime", "ExposureType", "FieldOfView", "FilterModel", "FilterPartNumber", "FilterSerialNumber", "FinalRatio", "FlashTime", "FMean", "FNumber", "Fnumber", "FocusDistance", "FocusMode", "FocusPos", "FocusStepCount", "FrameRate", "Gamma", "GBgain", "GBoff", "GHighLight", "GHL", "GMean", "GPSAltitude", "GPSDOP", "GPSImgDirection", "GPSImgDirectionRef", "GPSLatitude", "GPSLatitudeRef", "GPSLongitude", "GPSLongitudeRef", "GPSMapDatum", "GPSTrack", "GPSTrackRef", "GPSValid", "GPSVersionID", "GRgain", "GRoff", "GSd", "GSD", "HDRGainCurve", "HDRGainCurveSize", "HDRSetting", "ID", "ImageHeight", "ImageSize", "ImageWidth", "IRWindowTemperature", "IRWindowTransmission", "Isotherm1Color", "Isotherm2Color", "JPEG1", "LensModel", "LensPartNumber", "LensProjection", "LensSerialNumber", "LightS", "Macro", "Mean", "Meas1Label", "Meas1Params", "Meas1Type", "Meas2Label", "Meas2Params", "Meas2Type", "MediaUniqueID", "MetadataVersion", "Model", "MotorPos", "Offset", "OffsetX", "OffsetY", "OverflowColor", "Palette", "PaletteColors", "PaletteFileName", "PaletteMethod", "PaletteName", "PaletteStretch", "Param0", "PhotoResolution", "PicLen", "PreviewImageHeight", "PreviewImageWidth", "PreviewQuality", "Protect", "Protune", "Quality", "R5100", "Rate", "RawThermalImage", "RawThermalImageHeight", "RawThermalImageType", "RawThermalImageWidth", "RawValueMedian", "RawValueRange", "RawValueRangeMax", "RawValueRangeMin", "Real2IR", "ReflectedApparentTemperature", "RelativeHumidity", "Resolution", "ResolutionUnit", "REV", "Rgain", "RHighLight", "RHL", "RMean", "Roff", "RSd", "RSD", "RStrobe", "S0", "SerialNumber", "SpotMeter", "StrobeTime", "T0", "TagB", "TagQ", "TagR", "TagS", "ThmLen", "UnderflowColor", "WhiteBalance", "XResolution", "YLevel", "YResolution", "YTarget", "Zoom", "ZoomPos");
exports.DuckyTagsNames = (0, StrEnum_1.strEnum)("Quality");
exports.FlashPixTagsNames = (0, StrEnum_1.strEnum)("AudioStream", "CodePage", "CreatingApplication", "ExtensionClassID", "ExtensionCreateDate", "ExtensionDescription", "ExtensionModifyDate", "ExtensionName", "ExtensionPersistence", "PreviewImage", "PreviewImageHeight", "PreviewImageWidth", "ScreenNail", "UsedExtensionNumbers");
exports.EXIFTagsNames = (0, StrEnum_1.strEnum)("Acceleration", "ActiveArea", "AmbientTemperature", "AnalogBalance", "AntiAliasStrength", "ApertureValue", "Artist", "AsShotNeutral", "AsShotWhiteXY", "BaselineExposure", "BaselineNoise", "BaselineSharpness", "BayerGreenSplit", "BestQualityScale", "BitsPerSample", "BlackLevel", "BlackLevelBlue", "BlackLevelGreen", "BlackLevelRed", "BlackLevelRepeatDim", "BrightnessValue", "CameraElevationAngle", "CameraSerialNumber", "CFALayout", "CFAPattern", "CFAPlaneColor", "ChromaticAberrationCorrection", "ChromaticAberrationCorrParams", "ColorSpace", "CompositeImage", "CompositeImageCount", "CompositeImageExposureTimes", "CompressedBitsPerPixel", "Compression", "Contrast", "Copyright", "CreateDate", "CropBottom", "CropLeft", "CropRight", "CropTop", "CustomRendered", "DateTimeOriginal", "DefaultCropOrigin", "DefaultCropSize", "DefaultScale", "DefaultUserCrop", "DeviceSettingDescription", "DigitalZoomRatio", "DistortionCorrection", "DistortionCorrParams", "DNGBackwardVersion", "DNGVersion", "DocumentName", "ExifImageHeight", "ExifImageWidth", "ExifVersion", "ExposureCompensation", "ExposureIndex", "ExposureTime", "FileSource", "FlashEnergy", "FNumber", "FocalLength", "FocalLengthIn35mmFormat", "FocalPlaneResolutionUnit", "FocalPlaneXResolution", "FocalPlaneYResolution", "GainControl", "Gamma", "GPSAltitude", "GPSAltitudeRef", "GPSAreaInformation", "GPSDateStamp", "GPSDestBearing", "GPSDestBearingRef", "GPSDestDistance", "GPSDestLatitude", "GPSDestLatitudeRef", "GPSDestLongitude", "GPSDestLongitudeRef", "GPSDifferential", "GPSDOP", "GPSHPositioningError", "GPSImgDirection", "GPSImgDirectionRef", "GPSLatitude", "GPSLatitudeRef", "GPSLongitude", "GPSLongitudeRef", "GPSMapDatum", "GPSMeasureMode", "GPSProcessingMethod", "GPSSatellites", "GPSStatus", "GPSTimeStamp", "GPSTrack", "GPSTrackRef", "GPSVersionID", "HighISOMultiplierBlue", "HighISOMultiplierGreen", "HighISOMultiplierRed", "HostComputer", "ImageDescription", "ImageHeight", "ImageNumber", "ImageTitle", "ImageWidth", "ISO", "ISOSpeed", "JpgFromRaw", "JpgFromRawLength", "JpgFromRawStart", "LensInfo", "LensMake", "LensModel", "LensSerialNumber", "LightSource", "LinearityLimitBlue", "LinearityLimitGreen", "LinearityLimitRed", "LinearizationTable", "LinearResponseLimit", "Make", "MakerNoteSafety", "MakerNoteSamsung1a", "MakerNoteUnknownBinary", "MakerNoteUnknownText", "MaxApertureValue", "MeteringMode", "Model", "Model2", "ModifyDate", "Noise", "NoiseProfile", "NoiseReductionApplied", "NoiseReductionParams", "OffsetSchema", "OffsetTime", "OffsetTimeDigitized", "OffsetTimeOriginal", "Orientation", "OtherImage", "OtherImageLength", "OtherImageStart", "OwnerName", "Padding", "PageName", "PanasonicRawVersion", "Photographer", "PhotometricInterpretation", "PlanarConfiguration", "Pressure", "PreviewColorSpace", "PreviewDateTime", "PreviewImage", "PreviewImageLength", "PreviewImageStart", "PreviewTIFF", "PrimaryChromaticities", "ProcessingSoftware", "ProfileName", "Rating", "RawDataOffset", "RawDataUniqueID", "RawFormat", "RawImageSegmentation", "RecommendedExposureIndex", "ReferenceBlackWhite", "RelatedImageFileFormat", "RelatedImageHeight", "RelatedImageWidth", "RelatedSoundFile", "ResolutionUnit", "RowsPerStrip", "SamplesPerPixel", "Saturation", "SceneType", "SemanticName", "SensingMethod", "SensitivityType", "SensorBottomBorder", "SensorHeight", "SensorLeftBorder", "SensorRightBorder", "SensorTopBorder", "SensorWidth", "SerialNumber", "ShutterSpeedValue", "Software", "SonyCropSize", "SonyCropTopLeft", "SonyRawFileType", "SonyRawImageSize", "SonyToneCurve", "SpatialFrequencyResponse", "SRawType", "StripByteCounts", "StripOffsets", "SubfileType", "SubjectArea", "SubjectDistance", "SubjectDistanceRange", "SubSecTime", "SubSecTimeDigitized", "SubSecTimeOriginal", "ThumbnailImage", "ThumbnailTIFF", "TileByteCounts", "TileLength", "TileOffsets", "TileWidth", "TimeZoneOffset", "TransferFunction", "UniqueCameraModel", "UserComment", "VignettingCorrection", "VignettingCorrParams", "WaterDepth", "WBBlueLevel", "WBGreenLevel", "WBRedLevel", "WhiteBalance", "WhiteLevel", "WhitePoint", "XiaomiModel", "XPAuthor", "XPComment", "XPKeywords", "XPSubject", "XPTitle", "XResolution", "YCbCrCoefficients", "YCbCrPositioning", "YCbCrSubSampling", "YResolution");
exports.JPEGTagsNames = (0, StrEnum_1.strEnum)("UniformResourceName");
exports.JSONTagsNames = (0, StrEnum_1.strEnum)("AIScene", "FilterId", "Hdr", "Mirror", "OpMode", "SensorType", "ZoomMultiple");
exports.JUMBFTagsNames = (0, StrEnum_1.strEnum)("Actions", "Alg", "Exclusions", "Hash", "InstanceID", "Item0", "Item1", "Item3", "JUMDLabel", "JUMDType", "Pad", "Pad2", "Parts", "Signature");
exports.MPFTagsNames = (0, StrEnum_1.strEnum)("DependentImage1EntryNumber", "DependentImage2EntryNumber", "ImageUIDList", "MPFVersion", "MPImageFlags", "MPImageFormat", "MPImageLength", "MPImageStart", "MPImageType", "NumberOfImages", "PreviewImage", "TotalFrames");
exports.MetaTagsNames = (0, StrEnum_1.strEnum)("BorderID", "BorderLocation", "BorderName", "BordersVersion", "BorderType", "CameraOwner", "CaptureConditionsPAR", "DigitalEffectsName", "DigitalEffectsType", "DigitalEffectsVersion", "EditTagArray", "FilmGencode", "FilmProductCode", "FilmSize", "FrameNumber", "ImageSourceEK", "MetadataNumber", "ModelAndVersion", "SerialNumber", "WatermarkType");
exports.PanasonicRawTagsNames = (0, StrEnum_1.strEnum)("ApertureValue", "DistortionCorrection", "DistortionScale", "FlashFired", "FocalLengthIn35mmFormat", "FocusStepCount", "FocusStepNear", "LensTypeMake", "LensTypeModel", "NumWBEntries", "Orientation", "ShutterSpeedValue", "WhiteBalanceSet");
exports.PhotoshopTagsNames = (0, StrEnum_1.strEnum)("CopyrightFlag", "GlobalAltitude", "GlobalAngle", "HasRealMergedData", "IPTCDigest", "NumSlices", "PhotoshopFormat", "PhotoshopQuality", "PhotoshopThumbnail", "PixelAspectRatio", "PrintPosition", "PrintScale", "PrintStyle", "ReaderName", "SlicesGroupName", "WriterName", "XResolution", "YResolution");
exports.PrintIMTagsNames = (0, StrEnum_1.strEnum)("PrintIMVersion");
exports.IPTCTagsNames = (0, StrEnum_1.strEnum)("ApplicationRecordVersion", "Caption-Abstract", "Category", "City", "CodedCharacterSet", "Contact", "CopyrightNotice", "DateCreated", "DateSent", "DateTimeCreated", "Destination", "DigitalCreationDate", "DigitalCreationTime", "EnvelopeNumber", "EnvelopePriority", "EnvelopeRecordVersion", "FileFormat", "FileVersion", "Headline", "Keywords", "ObjectName", "OriginalTransmissionReference", "OriginatingProgram", "Prefs", "ProgramVersion", "ServiceIdentifier", "Source", "SpecialInstructions", "SupplementalCategories", "TimeCreated", "TimeSent", "Urgency");
exports.QuickTimeTagsNames = (0, StrEnum_1.strEnum)("AndroidCaptureFPS", "AndroidVersion", "AndroidVideoTemporalLayersCount", "AudioBitsPerSample", "AudioChannels", "AudioFormat", "AudioSampleRate", "AudioVendorID", "Author", "BackgroundColor", "Balance", "BitDepth", "ChapterListTrackID", "CleanApertureDimensions", "CompatibleBrands", "CompressorID", "CompressorName", "CompressorVersion", "ContentDescribes", "ContentIdentifier", "CreateDate", "CreationDate", "CurrentTime", "Duration", "EncodedPixelsDimensions", "FocalLengthIn35mmFormat", "FontName", "Format", "Gamma", "GenBalance", "GenFlags", "GenGraphicsMode", "GenMediaVersion", "GenOpColor", "GPSCoordinates", "GraphicsMode", "HandlerClass", "HandlerDescription", "HandlerType", "ImageHeight", "ImageWidth", "JpgFromRaw", "LayoutFlags", "LensModel", "LensSerialNumber", "LocationAccuracyHorizontal", "MajorBrand", "Make", "MatrixStructure", "MediaCreateDate", "MediaDataOffset", "MediaDataSize", "MediaDuration", "MediaHeaderVersion", "MediaLanguageCode", "MediaModifyDate", "MediaTimeScale", "MediaUID", "MetaFormat", "MinorVersion", "Model", "ModifyDate", "MovieHeaderVersion", "NextTrackID", "OpColor", "OtherFormat", "PixelAspectRatio", "PlaybackFrameRate", "PlayMode", "PosterTime", "PreferredRate", "PreferredVolume", "PreviewDuration", "PreviewImage", "PreviewTime", "ProductionApertureDimensions", "PurchaseFileFormat", "SampleDuration", "SampleTime", "SelectionDuration", "SelectionTime", "SerialNumberHash", "Software", "SourceImageHeight", "SourceImageWidth", "TextColor", "TextFace", "TextFont", "TextSize", "TimecodeTrack", "TimeScale", "TrackCreateDate", "TrackDuration", "TrackHeaderVersion", "TrackID", "TrackLayer", "TrackModifyDate", "TrackVolume", "VendorID", "VideoFrameRate", "VideoFullRangeFlag", "XResolution", "YResolution");
exports.RAFTagsNames = (0, StrEnum_1.strEnum)("BitsPerSample", "BlackLevel", "ChromaticAberrationParams", "FujiLayout", "GeometricDistortionParams", "RAFCompression", "RawExposureBias", "RawImageAspectRatio", "RawImageCroppedSize", "RawImageCropTopLeft", "RawImageFullHeight", "RawImageFullSize", "RawImageFullWidth", "RawZoomActive", "RawZoomSize", "RawZoomTopLeft", "StripByteCounts", "StripOffsets", "VignettingParams", "XTransLayout");
exports.RIFFTagsNames = (0, StrEnum_1.strEnum)("AudioCodec", "AudioSampleCount", "AudioSampleRate", "AvgBytesPerSec", "BitsPerSample", "DateTimeOriginal", "Encoding", "FrameCount", "FrameRate", "ImageHeight", "ImageWidth", "MaxDataRate", "NumChannels", "Quality", "SampleRate", "SampleSize", "Software", "StreamCount", "StreamType", "VideoCodec", "VideoFrameCount", "VideoFrameRate");
exports.JFIFTagsNames = (0, StrEnum_1.strEnum)("JFIFVersion", "ResolutionUnit", "ThumbnailHeight", "ThumbnailImage", "ThumbnailTIFF", "ThumbnailWidth", "XResolution", "YResolution");
exports.MakerNotesTagsNames = (0, StrEnum_1.strEnum)("AccelerationTracking", "Accelerometer", "AccelerometerX", "AccelerometerY", "AccelerometerZ", "ActionInAFCCont", "ActionPriority", "ActualCompensation", "AddIPTCInformation", "ADJDebugInfo", "AdjustmentMode", "ADLBracketingStep", "ADLBracketingType", "AdvancedSceneType", "AEAperture", "AEApertureSteps", "AEAverage", "AEBAutoCancel", "AEBBracketValue", "AEBracketingSteps", "AEBSequence", "AEBSequenceAutoCancel", "AEBShotCount", "AEBXv", "AEDebugInfo", "AEExposureTime", "AEHistogramInfo", "AELButton", "AELExposureIndicator", "AELiveViewHistogramInfo", "AELiveViewLocalHistogram", "AELocalHistogram", "AELock", "AELockButton", "AELockButtonPlusDials", "AELockMeterModeAfterFocus", "AEMaxAperture", "AEMeteringMode", "AEMeteringSegments", "AEMicroadjustment", "AEMinAperture", "AEMinExposureTime", "AEProgramMode", "AEStable", "AETarget", "AEWhiteBalance", "AEXv", "AFAdjustment", "AFAndMeteringButtons", "AFAperture", "AFAreaHeight", "AFAreaIllumination", "AFAreaMode", "AFAreaModeSetting", "AFAreas", "AFAreaSelectMethod", "AFAreaSize", "AFAreaWidth", "AFAreaXPosition", "AFAreaXPositions", "AFAreaYPosition", "AFAreaYPositions", "AFAssist", "AFAssistBeam", "AFAssistLamp", "AFButtonPressed", "AFCHold", "AFConfidence", "AFCoordinatesAvailable", "AFCPointTracking", "AFCSensitivity", "AFDebugInfo", "AFDefocus", "AFDetectionMethod", "AFDuringLiveView", "AFFineTune", "AFFineTuneAdj", "AFFineTuneAdjTele", "AFFineTuneIndex", "AFFocusArea", "AFFrameSize", "AFIlluminator", "AFImageHeight", "AFImageWidth", "AFInfo2Version", "AFIntegrationTime", "AFMeasuredDepth", "AFMicroAdj", "AFMicroAdjMode", "AFMicroAdjRegisteredLenses", "AFMicroadjustment", "AFMicroAdjValue", "AFModeRestrictions", "AFOnAELockButtonSwitch", "AFOnButton", "AFPerformance", "AFPoint", "AFPointActivationArea", "AFPointAreaExpansion", "AFPointAtShutterRelease", "AFPointAutoSelection", "AFPointBrightness", "AFPointDetails", "AFPointDisplayDuringFocus", "AFPointIllumination", "AFPointInFocus", "AFPointMode", "AFPointPosition", "AFPointRegistration", "AFPoints", "AFPointSel", "AFPointSelected", "AFPointSelection", "AFPointSelectionMethod", "AFPointSetting", "AFPointsInFocus", "AFPointsInFocus1D", "AFPointsInFocus5D", "AFPointSpotMetering", "AFPointsSelected", "AFPointsSpecial", "AFPointsUsed", "AFPredictor", "AFTracking", "AFType", "AFWithShutter", "AIServoFirstImagePriority", "AIServoImagePriority", "AIServoSecondImagePriority", "AIServoTrackingMethod", "AIServoTrackingSensitivity", "AISubjectTrackingMode", "AmbienceSelection", "AmbientTemperature", "AmbientTemperatureFahrenheit", "AndroidRelease", "AntiFlicker", "AntiShockWaitingTime", "Aperture", "ApertureLock", "ApertureRingUse", "ApertureSetting", "ApertureValue", "Application", "ApplySettingsToLiveView", "ApplyShootingMeteringMode", "ApproximateFNumber", "AppVersion", "ArtFilter", "ArtFilterEffect", "Artist", "ArtMode", "ArtModeParameters", "AspectFrame", "AssignBktButton", "AssignFuncButton", "AssignMovieFunc1ButtonPlusDials", "AssignMovieFunc2Button", "AssignMoviePreviewButtonPlusDials", "AssignMovieRecordButton", "AssignMovieRecordButtonPlusDials", "AssignMovieSubselector", "AssignMovieSubselectorPlusDials", "AssignRemoteFnButton", "AssistButtonFunction", "Audio", "AudioChannels", "AudioCompression", "AudioSampleRate", "AutoAFPointColorTracking", "AutoAperture", "AutoBracket", "AutoBracketingMode", "AutoBracketingSet", "AutoBracketOrder", "AutoBracketSet", "AutoDistortionControl", "AutoExposureBracketing", "AutoFlashISOSensitivity", "AutoFocusModeRestrictions", "AutoFP", "AutoISO", "AutoISOMax", "AutoISOMinShutterSpeed", "AutoLightingOptimizer", "AutoPortraitFramed", "AutoRotate", "AuxiliaryLens", "AvApertureSetting", "AverageBlackLevel", "AverageLV", "AvSettingWithoutLens", "BabyAge", "BabyName", "Barcode", "BaseExposureCompensation", "BaseISO", "BatteryLevel", "BatteryOrder", "BatteryState", "BatteryTemperature", "BatteryType", "BatteryVoltage", "BayerPattern", "Beep", "BeepPitch", "BeepVolume", "BestShotMode", "BitDepth", "BlackLevel", "BlackLevels", "BlackMaskBottomBorder", "BlackMaskLeftBorder", "BlackMaskRightBorder", "BlackMaskTopBorder", "BlackPoint", "BleachBypassToning", "BlueBalance", "BlurControl", "BoardTemperature", "BodyBatteryADLoad", "BodyBatteryADNoLoad", "BodyBatteryPercent", "BodyBatteryState", "BodyBatteryVoltage", "BodyFirmware", "BodyFirmwareVersion", "BodySerialNumber", "BracketIncrement", "BracketingBurstOptions", "BracketMode", "BracketProgram", "BracketSequence", "BracketSet", "BracketSettings", "BracketShotNumber", "BracketStep", "BracketValue", "Brightness", "BrightnessValue", "BuildNumber", "BulbDuration", "BurstGroupID", "BurstMode", "BurstSpeed", "BurstUUID", "ButtonFunctionControlOff", "BWFilter", "BWMode", "CAFArea", "CAFGridSize", "CAFPointsInFocus", "CAFPointsSelected", "Calibration", "CameraDateTime", "CameraID", "CameraISO", "CameraModel", "CameraOrientation", "CameraPictureStyle", "CameraPitch", "CameraRoll", "CameraSettingsVersion", "CameraType", "CameraYaw", "CanonExposureMode", "CanonFileDescription", "CanonFileLength", "CanonFirmwareVersion", "CanonFlashMode", "CanonImageHeight", "CanonImageSize", "CanonImageType", "CanonImageWidth", "CanonModelID", "CardShutterLock", "CaseAutoSetting", "Categories", "Category", "CCDBoardVersion", "CCDScanMode", "CCDSensitivity", "CCDVersion", "CenterAFArea", "CenterFocusPoint", "CHModeShootingSpeed", "ChromaticAberrationCorr", "ChromaticAberrationCorrection", "ChromaticAberrationCorrParams", "ChromaticAberrationSetting", "ChrominanceNoiseReduction", "City", "City2", "Clarity", "ClarityControl", "ClearRetouch", "CmdDialsApertureSetting", "CmdDialsChangeMainSub", "CmdDialsMenuAndPlayback", "CmdDialsReverseRotation", "CmdDialsReverseRotExposureComp", "ColorAdjustment", "ColorAdjustmentMode", "ColorBalanceBlue", "ColorBalanceGreen", "ColorBalanceRed", "ColorBalanceVersion", "ColorBitDepth", "ColorBW", "ColorChromeEffect", "ColorChromeFXBlue", "ColorCompensationFilter", "ColorCompensationFilterCustom", "ColorCompensationFilterSet", "ColorControl", "ColorDataVersion", "ColorEffect", "ColorFilter", "ColorGain", "ColorHue", "ColorMatrix", "ColorMatrixA", "ColorMatrixB", "ColorMatrixNumber", "ColorMode", "ColorProfileSettings", "ColorSpace", "ColorTempAsShot", "ColorTempAuto", "ColorTempCloudy", "ColorTempCustom", "ColorTempDaylight", "ColorTemperatureAuto", "ColorTemperatureCustom", "ColorTemperatureSet", "ColorTemperatureSetting", "ColorTempFlash", "ColorTempFluorescent", "ColorTempKelvin", "ColorTempMeasured", "ColorTempShade", "ColorTempTungsten", "ColorTint", "ColorTone", "ColorToneAuto", "ColorToneFaithful", "ColorToneLandscape", "ColorToneNeutral", "ColorTonePortrait", "ColorToneStandard", "CommandDials", "CommandDialsApertureSetting", "CommandDialsChangeMainSub", "CommandDialsMenuAndPlayback", "CommandDialsReverseRotation", "CommanderChannel", "CommanderGroupAManualOutput", "CommanderGroupAMode", "CommanderGroupBManualOutput", "CommanderGroupBMode", "CommanderInternalFlash", "CommanderInternalManualOutput", "CommanderInternalTTLCompBuiltin", "CommanderInternalTTLCompGroupA", "CommanderInternalTTLCompGroupB", "Compass", "ComponentBitDepth", "ComponentVersion", "CompositeImageMode", "CompositionAdjust", "CompositionAdjustRotation", "CompositionAdjustX", "CompositionAdjustY", "CompressedImageSize", "Compression", "CompressionFactor", "CompressionRatio", "CompressorVersion", "ContentIdentifier", "ContinuousBracketing", "ContinuousDrive", "ContinuousModeDisplay", "ContinuousModeLiveView", "ContinuousShootingSpeed", "ContinuousShotLimit", "Contrast", "ContrastAuto", "ContrastCurve", "ContrastDetectAFArea", "ContrastDetectAFInFocus", "ContrastFaithful", "ContrastHighlight", "ContrastHighlightShadowAdj", "ContrastLandscape", "ContrastMode", "ContrastMonochrome", "ContrastNeutral", "ContrastPortrait", "ContrastSetting", "ContrastShadow", "ContrastStandard", "ControlDialSet", "ControllerBoardVersion", "ControlMode", "ControlRingResponse", "ControlRingRotation", "ConversionLens", "Converter", "Copyright", "CorrelatedColorTemp", "Country", "CountryCode", "CPUFirmwareVersion", "CPUVersions", "CreateDate", "CreativeStyle", "CreativeStyleSetting", "CropArea", "CropBottomMargin", "CropHeight", "CropHiSpeed", "CropLeft", "CropLeftMargin", "CropMode", "CroppedImageHeight", "CroppedImageLeft", "CroppedImageTop", "CroppedImageWidth", "CropRightMargin", "CropTop", "CropTopMargin", "CropWidth", "CrossProcess", "CustomControls", "CustomizeDials", "CustomPictureStyleFileName", "CustomRendered", "CustomSaturation", "CustomSettingsAllDefault", "CustomSettingsBank", "CustomWBBlueLevel", "CustomWBError", "CustomWBGreenLevel", "CustomWBRedLevel", "CustomWBSetting", "DarkFocusEnvironment", "DataDump", "DataScaling", "Date", "DateDisplayFormat", "DateImprint", "DateStampMode", "DateTimeOriginal", "DateTimeStamp", "DateTimeUTC", "DaylightSavings", "DECPosition", "DeletedImageCount", "DestinationCity", "DestinationCityCode", "DestinationDST", "DevelopmentDynamicRange", "DeviceCodename", "DeviceHardwareRevision", "DeviceMake", "DeviceModel", "DeviceType", "DialDirectionTvAv", "DiffractionCompensation", "DigitalFilter", "DigitalGain", "DigitalICE", "DigitalLensOptimizer", "DigitalLensOptimizerSetting", "DigitalZoom", "DigitalZoomOn", "DigitalZoomRatio", "DirectoryIndex", "DirectoryNumber", "DispButton", "DisplayAllAFPoints", "DisplayAperture", "DistortionControl", "DistortionCorrection", "DistortionCorrectionSetting", "DistortionCorrectionValue", "DistortionCorrectionVersion", "DistortionCorrParams", "DistortionCorrParamsPresent", "DriveMode", "DriveModeSetting", "DSPFirmwareVersion", "DualPixelRaw", "Duration", "DustRemovalData", "DXCropAlert", "DynamicAFArea", "DynamicAreaAFAssist", "DynamicAreaAFDisplay", "DynamicRange", "DynamicRangeBoost", "DynamicRangeOptimizer", "DynamicRangeOptimizerBracket", "DynamicRangeOptimizerLevel", "DynamicRangeOptimizerMode", "DynamicRangeOptimizerSetting", "DynamicRangeSetting", "EasyExposureComp", "EasyMode", "EffectiveMaxAperture", "ElectronicFrontCurtainShutter", "Emissivity", "EnergySavingMode", "Enhancement", "Enhancer", "EpsonImageHeight", "EpsonImageWidth", "EpsonSoftware", "EquipmentVersion", "ETTLII", "EventNumber", "EVSteps", "ExitPupilPosition", "ExposureBracketingIndicatorLast", "ExposureBracketShotNumber", "ExposureBracketStepSize", "ExposureBracketValue", "ExposureCompAutoCancel", "ExposureCompensation", "ExposureCompensationMode", "ExposureCompensationSet", "ExposureCompensationSetting", "ExposureCompStepSize", "ExposureControlStep", "ExposureDifference", "ExposureIndicator", "ExposureLevelIncrements", "ExposureModeInManual", "ExposureShift", "ExposureTime", "ExposureTimeMax", "ExposureTimeMin", "ExposureTuning", "EXRAuto", "EXRMode", "ExtendedMenuBanks", "ExtendedShutterSpeeds", "ExtendedWBDetect", "Extender", "ExtenderFirmwareVersion", "ExtenderModel", "ExtenderSerialNumber", "ExtenderStatus", "ExternalFlash", "ExternalFlashBounce", "ExternalFlashCompensation", "ExternalFlashExposureComp", "ExternalFlashFirmware", "ExternalFlashFlags", "ExternalFlashGuideNumber", "ExternalFlashGValue", "ExternalFlashMode", "ExternalFlashReadyState", "ExternalFlashStatus", "ExternalFlashZoom", "ExternalFlashZoomOverride", "ExternalSensorBrightnessValue", "ExtraInfoVersion", "EyeDetection", "EyeStartAF", "FaceDetect", "FaceDetectArea", "FaceDetectFrameCrop", "FaceDetectFrameSize", "FaceDetection", "FaceElementPositions", "FaceElementSelected", "FaceElementTypes", "FaceImageSize", "FaceInfoLength", "FaceInfoOffset", "FaceName", "FacePositions", "FacesDetected", "FacesDetectedA", "FacesDetectedB", "FacesRecognized", "FaceWidth", "Fade", "FEMicroadjustment", "FileFormat", "FileIndex", "FileInfoVersion", "FileNumber", "FileNumberMemory", "FileSource", "FillFlashAutoReduction", "FilmGrainEffect", "FilmMode", "FilmType", "FilterEffect", "FilterEffectAuto", "FilterEffectMonochrome", "FinderDisplayDuringExposure", "FineSharpness", "FinishedImage", "Firmware", "FirmwareDate", "FirmwareID", "FirmwareName", "FirmwareRevision", "FirstFrameActionInAFC", "FisheyeFilter", "FlashAction", "FlashActionExternal", "FlashActivity", "FlashBatteryLevel", "FlashBias", "FlashBits", "FlashBurstPriority", "FlashButtonFunction", "FlashChargeLevel", "FlashColorFilter", "FlashCommanderMode", "FlashCompensation", "FlashControl", "FlashControlMode", "FlashCurtain", "FlashDefault", "FlashDevice", "FlashDistance", "FlashExposureBracketValue", "FlashExposureComp", "FlashExposureIndicator", "FlashExposureIndicatorLast", "FlashExposureIndicatorNext", "FlashExposureLock", "FlashFired", "FlashFiring", "FlashFirmwareVersion", "FlashFocalLength", "FlashFunction", "FlashGNDistance", "FlashGroupACompensation", "FlashGroupAControlMode", "FlashGroupBCompensation", "FlashGroupBControlMode", "FlashGroupCCompensation", "FlashGroupCControlMode", "FlashGuideNumber", "FlashIlluminationPattern", "FlashInfoVersion", "FlashIntensity", "FlashLevel", "FlashMasterControlMode", "FlashMetering", "FlashMeteringMode", "FlashMeteringSegments", "FlashMode", "FlashModel", "FlashOptions", "FlashRemoteControl", "FlashSerialNumber", "FlashSetting", "FlashSource", "FlashStatus", "FlashStatusExternal", "FlashSyncMode", "FlashSyncSpeedAv", "FlashThreshold", "FlashType", "FlashWarning", "FlexibleSpotPosition", "FlickAdvanceDirection", "FlickerReduce", "FlickerReduction", "FlickerReductionIndicator", "FlickerReductionShooting", "FlightDegree", "FlightSpeed", "FNumber", "FocalLength", "FocalLengthTeleZoom", "FocalPlaneAFPointArea", "FocalUnits", "FocusArea", "FocusAreaSelection", "FocusBracket", "FocusBracketStepSize", "FocusContinuous", "FocusDistance", "FocusDistanceLower", "FocusDistanceRange", "FocusDistanceUpper", "FocusFrameSize", "FocusHoldButton", "FocusInfoVersion", "FocusingScreen", "FocusLocation", "FocusLocked", "FocusMode", "FocusModeSetting", "FocusModeSwitch", "FocusPeakingHighlightColor", "FocusPeakingLevel", "FocusPointBrightness", "FocusPointPersistence", "FocusPointSchema", "FocusPointSelectionSpeed", "FocusPosition", "FocusPositionHorizontal", "FocusPositionVertical", "FocusProcess", "FocusRange", "FocusRangeIndex", "FocusResult", "FocusRingRotation", "FocusSetting", "FocusShiftExposureLock", "FocusShiftInterval", "FocusShiftNumberShots", "FocusShiftShooting", "FocusShiftStepWidth", "FocusStatus", "FocusStepCount", "FocusStepInfinity", "FocusStepNear", "FocusTrackingLockOn", "FolderNumber", "FrameCount", "FrameNumber", "FrameRate", "FramingGridDisplay", "FreeBytes", "FujiModel", "FullImageSize", "FullPressSnap", "Func1Button", "Func1ButtonPlusDials", "Func2Button", "Func3Button", "FuncButton", "FuncButtonPlusDials", "FunctionButton", "GainBase", "GEImageSize", "GEMake", "GEModel", "GimbalDegree", "Gradation", "GrainEffectSize", "GrainyBWFilter", "GreenGain", "GridDisplay", "GripBatteryADLoad", "GripBatteryADNoLoad", "GripBatteryPercent", "GripBatteryVoltage", "GroupAreaAFIllumination", "HDMIBitDepth", "HDMIExternalRecorder", "HDMIOutputRange", "HDMIOutputResolution", "HDREffect", "HDRGain", "HDRHeadroom", "HDRInfoVersion", "HDRLevel", "HDRPSoftware", "HDRSetting", "HDRSmoothing", "HiddenDataLength", "HiddenDataOffset", "HighFrameRate", "Highlight", "Highlights", "HighlightTone", "HighlightTonePriority", "HighlightWarning", "HighLowKeyAdj", "HighSpeedSync", "Histogram", "HometownCity", "HometownCityCode", "HometownDST", "HostSoftwareExportVersion", "HostSoftwareRendering", "Hue", "HueAdjust", "HueAdjustment", "HyperlapsDebugInfo", "Illumination", "ImageAdjustment", "ImageArea", "ImageAuthentication", "ImageBoundary", "ImageCount", "ImageData", "ImageDataSize", "ImageEditCount", "ImageEditing", "ImageEffects", "ImageGeneration", "ImageHeight", "ImageIDNumber", "ImageName", "ImageNumber", "ImageOptimization", "ImageProcessing", "ImageProcessingVersion", "ImageQuality", "ImageReview", "ImageReviewTime", "ImageRotated", "ImageSizeRAW", "ImageStabilization", "ImageStabilizationSetting", "ImageStyle", "ImageTemperatureMax", "ImageTemperatureMin", "ImageWidth", "InfoButtonWhenShooting", "InfraredIlluminator", "InitialAFPointAIServoAF", "InitialAFPointInServo", "InitialZoomLiveView", "InitialZoomSetting", "InitParamsText", "InstantPlaybackSetup", "InstantPlaybackTime", "IntelligentAuto", "IntelligentContrast", "IntelligentExposure", "IntelligentResolution", "InternalFlash", "InternalFlashMode", "InternalFlashStrength", "InternalFlashTable", "InternalNDFilter", "InternalSerialNumber", "IntervalDurationHours", "IntervalDurationMinutes", "IntervalDurationSeconds", "IntervalExposureSmoothing", "IntervalLength", "IntervalMode", "IntervalNumber", "IntervalPriority", "Intervals", "IntervalShooting", "ISO", "ISO2", "ISOAuto", "ISOAutoFlashLimit", "ISOAutoHiLimit", "ISOAutoMax", "ISOAutoMin", "ISOAutoMinSpeed", "ISOAutoShutterTime", "ISODisplay", "ISOExpansion", "ISOFloor", "ISOMax", "ISOMin", "ISOSelected", "ISOSelection", "ISOSensitivityStep", "ISOSetting", "ISOSpeedExpansion", "ISOSpeedIncrements", "ISOSpeedRange", "ISOStepSize", "ISOValue", "JPEGQuality", "JPGCompression", "JpgRecordedPixels", "KeepExposure", "KeystoneCompensation", "KeystoneDirection", "KeystoneValue", "KodakInfoType", "KodakMake", "KodakMaker", "KodakModel", "KodakVersion", "Landmark", "Language", "LastFileNumber", "LateralChromaticAberration", "LCDDisplayAtPowerOn", "LCDDisplayReturnToShoot", "LCDIllumination", "LCDIlluminationDuringBulb", "LCDPanels", "Lens", "LensApertureRange", "LensControlRing", "LensDataVersion", "LensDistortionParams", "LensDriveNoAF", "LensFirmware", "LensFirmwareVersion", "LensFocalLength", "LensFocalRange", "LensFocusFunctionButtons", "LensFormat", "LensFStops", "LensFunc1Button", "LensFunc2Button", "LensID", "LensIDNumber", "LensInfo", "LensMaxApertureRange", "LensModel", "LensModulationOptimizer", "LensMount", "LensMountType", "LensPositionAbsolute", "LensProperties", "LensSerialNumber", "LensShading", "LensShutterLock", "LensSpec", "LensSpecFeatures", "LensTemperature", "LensType", "LensType2", "LensType3", "LensTypeMake", "LensTypeModel", "LensZoomPosition", "LevelOrientation", "LightCondition", "LightingMode", "LightSource", "LightSourceSpecial", "LightSwitch", "LightValueCenter", "LightValuePeriphery", "LimitAFAreaModeSelection", "LinearityUpperMargin", "LinkAEToAFPoint", "LivePhotoVideoIndex", "LiveView", "LiveViewAF", "LiveViewAFAreaMode", "LiveViewAFMethod", "LiveViewAFMode", "LiveViewButtonOptions", "LiveViewExposureSimulation", "LiveViewFocusMode", "LiveViewMetering", "LiveViewMonitorOffTime", "LiveViewShooting", "LocalLocationName", "Location", "LocationInfoVersion", "LocationName", "LockMicrophoneButton", "LoggingMetadataText", "LongExposureNRUsed", "LowLightAF", "LuminanceNoiseAmplitude", "LuminanceNoiseReduction", "LVShootingAreaDisplay", "M16CVersion", "Macro", "MacroLED", "MacroMode", "MagicFilter", "MagnifiedView", "MainDialExposureComp", "Make", "MakerNoteOffset", "MakerNoteType", "MakerNoteVersion", "ManometerPressure", "ManometerReading", "ManualAFPointSelectPattern", "ManualFlash", "ManualFlashOutput", "ManualFlashStrength", "ManualFocusDistance", "ManualFocusPointIllumination", "ManualFocusRingInAFMode", "ManualTv", "MasterGain", "MatrixMetering", "MaxAnalogISO", "MaxAperture", "MaxApertureAtMaxFocal", "MaxApertureAtMinFocal", "MaxFaces", "MaxFocalLength", "MaxNumAFPoints", "MCCData", "MCUVersion", "MeasuredEV", "MeasuredLV", "MeasuredRGGB", "MeasuredRGGBData", "MemoryCardConfiguration", "MemoryCardNumber", "MenuButtonDisplayPosition", "MenuButtonReturn", "MergedImage", "MergedImages", "MetaVersion", "Metering", "MeteringButton", "MeteringFrameCount", "MeteringMode", "MeteringOffScaleIndicator", "MeteringTime", "MeterMode", "MidRangeSharpness", "MinAperture", "MinFocalLength", "MinFocusDistance", "MiniatureFilter", "MiniatureFilterOrientation", "MiniatureFilterParameter", "MiniatureFilterPosition", "MinimumISO", "MinoltaDate", "MinoltaImageSize", "MinoltaModelID", "MinoltaQuality", "MinoltaTime", "MirrorLockup", "ModeDialPosition", "Model", "ModelReleaseYear", "ModifiedColorTemp", "ModifiedDigitalGain", "ModifiedParamFlag", "ModifiedPictureStyle", "ModifiedSaturation", "ModifiedSensorBlueLevel", "ModifiedSensorRedLevel", "ModifiedSharpness", "ModifiedSharpnessFreq", "ModifiedToneCurve", "ModifiedWhiteBalance", "ModifiedWhiteBalanceBlue", "ModifiedWhiteBalanceRed", "MonitorBrightness", "MonitorDisplayOff", "MonitorOffTime", "MonochromeColor", "MonochromeFilterEffect", "MonochromeGrainEffect", "MonochromeProfileSettings", "MonochromeToning", "MonochromeVignetting", "MonthDayCreated", "MoonPhase", "MotionSensitivity", "MovieAFAreaMode", "MovieAFTrackingSensitivity", "MovieFlickerReduction", "MovieFunc1Button", "MovieFunc2Button", "MovieFunc3Button", "MovieFunctionButton", "MovieFunctionButtonPlusDials", "MovieHighlightDisplayPattern", "MovieHighlightDisplayThreshold", "MovieISOAutoControlManualMode", "MovieISOAutoHiLimit", "MovieLensControlRing", "MovieMultiSelector", "MoviePreviewButton", "MoviePreviewButtonPlusDials", "MovieShutterButton", "MovieSubSelectorAssignment", "MovieSubSelectorAssignmentPlusDials", "MovieWhiteBalanceSameAsPhoto", "MultiControllerWhileMetering", "MultiExposure", "MultiExposureAutoGain", "MultiExposureMode", "MultiExposureOverlayMode", "MultiExposureShots", "MultiExposureVersion", "MultiFrameNoiseReduction", "MultiFrameNREffect", "MultiFunctionLock", "MultipleExposureMode", "MultipleExposureSet", "MultiSelector", "MultiSelectorLiveView", "MyColorMode", "NDFilter", "NEFCompression", "NEFLinearizationTable", "NeutralDensityFilter", "NikonImageSize", "NikonMeteringMode", "NoiseFilter", "NoiseReduction", "NoiseReductionStrength", "NoMemoryCard", "NominalMaxAperture", "NominalMinAperture", "NormalWhiteLevel", "NumAFPoints", "NumberOffsets", "NumCAFPoints", "NumFaceElements", "NumFacePositions", "OISMode", "OKButton", "OlympusImageHeight", "OlympusImageWidth", "OneTouchWB", "OpticalVR", "OpticalZoom", "OpticalZoomCode", "OpticalZoomMode", "OpticalZoomOn", "OrderNumber", "OrientationLinkedAFPoint", "OriginalDecisionDataOffset", "OriginalDirectory", "OriginalFileName", "OriginalImageHeight", "OriginalImageWidth", "OriginalPayloadFrameCount", "OtherInfo", "OutputLUT", "OwnerName", "PaintingFilter", "PanasonicDateTime", "PanasonicExifVersion", "PanasonicImageHeight", "PanasonicImageWidth", "PanoramaAngle", "PanoramaCropBottom", "PanoramaCropLeft", "PanoramaCropRight", "PanoramaCropTop", "PanoramaDirection", "PanoramaFrameHeight", "PanoramaFrameWidth", "PanoramaFullHeight", "PanoramaFullWidth", "PanoramaMode", "PanoramaSize3D", "PanoramaSourceHeight", "PanoramaSourceWidth", "PayloadMetadataText", "PentaxImageSize", "PentaxModelID", "PentaxModelType", "PerChannelBlackLevel", "PeripheralIlluminationCorr", "PeripheralLighting", "PeripheralLightingSetting", "PeripheralLightingValue", "PhaseDetectAF", "PhotoEffect", "PhotoIdentifier", "PhotoInfoPlayback", "PhotosAppFeatureFlags", "PhotoShootingMenuBank", "PhotoShootingMenuBankImageArea", "PhotoStyle", "PictureControlAdjust", "PictureControlBase", "PictureControlName", "PictureControlQuickAdjust", "PictureControlVersion", "PictureEffect", "PictureFinish", "PictureMode", "PictureModeBWFilter", "PictureModeContrast", "PictureModeEffect", "PictureModeSaturation", "PictureModeSharpness", "PictureModeStrength", "PictureModeTone", "PictureProfile", "PictureStyle", "PictureStylePC", "PictureStyleUserDef", "Pitch", "PitchAngle", "PixelAspectRatio", "PixelShiftID", "PixelShiftInfo", "PixelShiftResolution", "PlaybackFlickDown", "PlaybackFlickUp", "PlaybackMenusTime", "PlaybackZoom", "PlayDisplay", "POILevel", "PopupFlash", "PortraitImpressionBalance", "PortraitRefiner", "PostFocusMerging", "PostReleaseBurstLength", "PowerAvailable", "PowerSource", "PowerUpTime", "PreCaptureFrames", "PreReleaseBurstLength", "PresetWhiteBalance", "PreviewButton", "PreviewButtonPlusDials", "PreviewImage", "PreviewImageBorders", "PreviewImageHeight", "PreviewImageLength", "PreviewImageStart", "PreviewImageValid", "PreviewImageWidth", "PreviewQuality", "PrioritySetupShutterRelease", "ProcessingNotes", "ProgramISO", "ProgramLine", "ProgramMode", "ProgramShift", "Quality", "QuickControlDialInMeter", "QuickShot", "QuietShutterShootingSpeed", "RangeFinder", "Rating", "RawAndJpgRecording", "RawBurstImageCount", "RawBurstImageNum", "RawDataByteOrder", "RawDataCFAPattern", "RawDataLength", "RawDepth", "RawDevArtFilter", "RawDevAutoGradation", "RawDevColorSpace", "RawDevContrastValue", "RawDevEditStatus", "RawDevelopmentProcess", "RawDevEngine", "RawDevExposureBiasValue", "RawDevGradation", "RawDevGrayPoint", "RawDevMemoryColorEmphasis", "RawDevNoiseReduction", "RawDevPictureMode", "RawDevPMContrast", "RawDevPMNoiseFilter", "RawDevPMPictureTone", "RawDevPMSaturation", "RawDevPMSharpness", "RawDevSaturationEmphasis", "RawDevSettings", "RawDevSharpnessValue", "RawDevVersion", "RawDevWBFineAdjustment", "RawDevWhiteBalance", "RawDevWhiteBalanceValue", "RawImageCenter", "RawImageHeight", "RawImageWidth", "RawJpgQuality", "RawJpgSize", "RawMeasuredRGGB", "RearControPanelDisplay", "RearDisplay", "RecordDisplay", "RecordID", "RecordingFormat", "RecordingMode", "RecordMode", "RecordShutterRelease", "RectifaceText", "RedBalance", "RedEyeReduction", "ReleaseButtonToUseDial", "ReleaseMode", "RemoteOnDuration", "RepeatingFlashCount", "RepeatingFlashOutput", "RepeatingFlashOutputExternal", "RepeatingFlashRate", "Resaved", "Resolution", "ResolutionMode", "ResolutionUnit", "RestrictDriveModes", "RetouchHistory", "RetouchInfoVersion", "RetouchNEFProcessing", "RetractLensOnPowerOff", "ReverseExposureCompDial", "ReverseFocusRing", "ReverseShutterSpeedAperture", "RFLensMFFocusRingSensitivity", "RicohDate", "RicohImageHeight", "RicohImageWidth", "RicohMake", "RicohModel", "Roll", "RollAngle", "ROMOperationMode", "Rotation", "RunTimeEpoch", "RunTimeFlags", "RunTimeScale", "RunTimeValue", "SafetyShift", "SafetyShiftInAvOrTv", "SameExposureForNewAperture", "SamsungModelID", "SanyoQuality", "SanyoThumbnail", "Saturation", "SaturationAdj", "SaturationAuto", "SaturationFaithful", "SaturationLandscape", "SaturationNeutral", "SaturationPortrait", "SaturationSetting", "SaturationStandard", "SaveFocus", "ScanImageEnhancer", "SceneAssist", "SceneDetect", "SceneMode", "SceneModeUsed", "SceneRecognition", "SceneSelect", "ScreenTips", "SecondarySlotFunction", "SelectableAFPoint", "SelectAFAreaSelectMode", "SelfTimer", "SelfTimerInterval", "SelfTimerTime", "SemanticStyle", "SemanticStylePreset", "SensitivityAdjust", "SensitivitySteps", "Sensor", "SensorBitDepth", "SensorBlueLevel", "SensorBottomBorder", "SensorCalibration", "SensorCleaning", "SensorFullHeight", "SensorFullWidth", "SensorHeight", "SensorID", "SensorLeftBorder", "SensorPixelSize", "SensorRedLevel", "SensorRightBorder", "SensorSize", "SensorTemperature", "SensorTopBorder", "SensorType", "SensorWidth", "Sequence", "SequenceFileNumber", "SequenceImageNumber", "SequenceLength", "SequenceNumber", "SequenceShotInterval", "SequentialShot", "SerialNumber", "ServoAFCharacteristics", "SetButtonCrossKeysFunc", "SetButtonWhenShooting", "ShadingCompensation", "Shadow", "ShadowCorrection", "Shadows", "ShadowTone", "ShakeReduction", "Sharpening", "SharpnessAuto", "SharpnessFactor", "SharpnessFaithful", "SharpnessFreqTable", "SharpnessFrequency", "SharpnessLandscape", "SharpnessMonochrome", "SharpnessNeutral", "SharpnessPortrait", "SharpnessRange", "SharpnessSetting", "SharpnessStandard", "SharpnessTable", "ShootingInfoDisplay", "ShootingInfoMonitorOffTime", "ShootingMode", "ShootingModeSetting", "ShortOwnerName", "ShortReleaseTimeLag", "ShotInfoVersion", "ShotLogDataText", "ShotNumber", "ShotNumberSincePowerUp", "ShotParamsText", "ShotsPerInterval", "Shutter", "ShutterAELButton", "ShutterCount", "ShutterCount2", "ShutterCount3", "ShutterCurtainSync", "ShutterMode", "ShutterReleaseMethod", "ShutterReleaseNoCFCard", "ShutterReleaseTiming", "ShutterSpeed", "ShutterSpeedLock", "ShutterSpeedRange", "ShutterSpeedSetting", "ShutterSpeedValue", "ShutterType", "SignalToNoiseRatio", "SilentPhotography", "SingleFrame", "SingleFrameBracketing", "SlaveFlashMeteringSegments", "SlowShutter", "SmartAlbumColor", "SmileShutter", "SmileShutterMode", "SoftFocusFilter", "SoftSkinEffect", "Software", "SoftwareDate", "SonyDateTime", "SonyDateTime2", "SonyExposureTime", "SonyFNumber", "SonyImageHeight", "SonyImageHeightMax", "SonyImageSize", "SonyImageWidth", "SonyImageWidthMax", "SonyISO", "SonyMaxAperture", "SonyMaxApertureValue", "SonyMinAperture", "SonyModelID", "SonyQuality", "SourceDirectoryIndex", "SourceFileIndex", "SpecialEffectLevel", "SpecialEffectMode", "SpecialEffectSetting", "SpecularWhiteLevel", "SpeedX", "SpeedY", "SpeedZ", "SportEvents", "SpotFocusPointX", "SpotFocusPointY", "SpotMeterLinkToAFPoint", "SRActive", "SRAWQuality", "SRFocalLength", "SRHalfPressTime", "SRResult", "StandbyMonitorOffTime", "StandbyTimer", "StartMovieShooting", "State", "StaticMetadataText", "StepCropShooting", "StopsAboveBaseISO", "StorageMethod", "StoreByOrientation", "SubDialFrameAdvance", "SubjectDetectArea", "SubjectDetectDetail", "SubjectDetectFrameSize", "SubjectDetection", "SubjectDetectStatus", "SubjectMotion", "SubjectProgram", "SubjectRecognition", "SubjectSwitching", "SubjectToDetect", "SubSelector", "SubSelectorAssignment", "SubSelectorCenter", "SubSelectorPlusDials", "SummaryText", "SuperimposedDisplay", "SuperMacro", "SvISOSetting", "SweepPanoramaDirection", "SweepPanoramaFieldOfView", "SweepPanoramaSize", "SwitchToRegisteredAFPoint", "SyncReleaseMode", "TargetAperture", "TargetCompressionRatio", "TargetDistanceSetting", "TargetExposureTime", "TargetImageType", "Teleconverter", "TextEncoding", "TextStamp", "ThumbnailFileName", "ThumbnailHeight", "ThumbnailImage", "ThumbnailImageValidArea", "ThumbnailWidth", "TiffMeteringImageHeight", "TiffMeteringImageWidth", "Time", "TimeCreated", "TimeLapseShotNumber", "TimeLogText", "TimerLength", "TimeSincePowerOn", "TimeStamp", "TimeZone", "TimeZoneCity", "TimeZoneCode", "TimeZoneInfo", "Title", "ToneCurve", "ToneCurveMatching", "ToneCurveTable", "ToneLevel", "ToningEffect", "ToningEffectAuto", "ToningEffectMonochrome", "ToningSaturation", "TotalZoom", "ToyCameraFilter", "Transform", "TrashButtonFunction", "TravelDay", "TriggerMode", "TvExposureTimeSetting", "UniqueID", "UnknownNumber", "UnsharpMaskFineness", "UnsharpMaskThreshold", "UnusedLoggingMetadata", "UsableMeteringModes", "UsableShootingModes", "USBPowerDelivery", "UserDef1PictureStyle", "UserDef2PictureStyle", "UserDef3PictureStyle", "UserLabel", "UserProfile", "USMLensElectronicMF", "ValidAFPoints", "ValidBits", "VariableLowPassFilter", "VariProgram", "VerticalAFOnButton", "VerticalFuncButton", "VerticalFuncButtonPlusDials", "VerticalMovieAFOnButton", "VerticalMovieFuncButton", "VerticalMultiSelector", "VFDisplayIllumination", "VibrationReduction", "VideoCodec", "VideoFrameRate", "VideoPreburst", "ViewfinderDisplay", "ViewfinderWarning", "ViewInfoDuringExposure", "ViewingMode", "Vignette", "VignetteControl", "VignetteCorrectionVersion", "Vignetting", "VignettingCorrection", "VignettingCorrParams", "VignettingCorrVersion", "VoiceMemo", "VRInfoVersion", "VRMode", "VRType", "WatercolorFilter", "WBBlue", "WBBlueLevel", "WBBracketingSteps", "WBBracketMode", "WBBracketShotNumber", "WBBracketValueAB", "WBBracketValueGM", "WBButtonPlaybackMode", "WBGreen", "WBGreenLevel", "WBMediaImageSizeSetting", "WBMode", "WBRed", "WBRedLevel", "WBScale", "WBShiftAB", "WBShiftCreativeControl", "WBShiftGM", "WBShiftIntelligentAuto", "WhiteBalance", "WhiteBalanceAutoAdjustment", "WhiteBalanceBias", "WhiteBalanceBlue", "WhiteBalanceBracket", "WhiteBalanceBracketing", "WhiteBalanceMatching", "WhiteBalanceMode", "WhiteBalanceRed", "WhiteBalanceSet", "WhiteBalanceSetting", "WhiteBalanceTable", "WhiteBalanceTemperature", "WhiteBoard", "WhiteLevel", "WhitePoint", "WholeAreaTracking", "WideAdapter", "WideFocusZone", "WideRange", "WorldTimeLocation", "X3FillLight", "Xidiri", "XResolution", "Yaw", "YCbCrCoefficients", "YCbCrPositioning", "YearCreated", "YResolution", "ZoneMatching", "ZoneMatchingMode", "ZoneMatchingOn", "ZoneMatchingValue", "ZoomedPreviewImage", "ZoomedPreviewLength", "ZoomedPreviewSize", "ZoomedPreviewStart", "ZoomSourceWidth", "ZoomStepCount", "ZoomTargetWidth");
exports.XMPTagsNames = (0, StrEnum_1.strEnum)("About", "AbsoluteAltitude", "Album", "AlreadyApplied", "AltitudeType", "ApertureValue", "ApproximateFocusDistance", "AsrClimaxDuration", "AsrClimaxScene", "AsrIsMacroRange", "AsrSceneCondition", "AsrSceneMode", "AutoLateralCA", "AuxiliaryImageType", "BandName", "BitsPerSample", "BlueHue", "BlueSaturation", "Brightness", "BrightnessValue", "BurstID", "BurstPrimary", "CameraBurstID", "CameraFacing", "CameraProfile", "CameraProfileDigest", "CameraSerialNumber", "CameraUnit", "CamReverse", "CaptureMode", "CaptureSoftware", "CatalogSets", "Categories", "CellGlobalID", "CellR", "CellTowerID", "CentralTemperature", "CentralWavelength", "Changes", "ChromaticAberrationB", "ChromaticAberrationR", "CircularGradientBasedCorrections", "City", "ColorClass", "ColorGradeBlending", "ColorGradeGlobalHue", "ColorGradeGlobalLum", "ColorGradeGlobalSat", "ColorGradeHighlightLum", "ColorGradeMidtoneHue", "ColorGradeMidtoneLum", "ColorGradeMidtoneSat", "ColorGradeShadowLum", "ColorLabel", "Colorlabels", "ColorMode", "ColorNoiseReduction", "ColorNoiseReductionDetail", "ColorNoiseReductionSmoothness", "ColorSpace", "Comment", "CompressedBitsPerPixel", "Compression", "Container", "ContainerDirectory", "Contrast", "Country", "CountryCode", "CreateDate", "CreationTime", "Creator", "CreatorAppID", "CreatorContactInfo", "CreatorOpenWithUIOptions", "Creatortool", "CreatorTool", "CropAngle", "CropBottom", "CropConstrainToWarp", "CropHeight", "CropLeft", "CroppedAreaImageHeightPixels", "CroppedAreaImageWidthPixels", "CroppedAreaLeftPixels", "CroppedAreaTopPixels", "CropRight", "CropTop", "CropWidth", "CustomRendered", "DateAcquired", "DateCreated", "DateTime", "DateTimeDigitized", "DateTimeOriginal", "DateUTC", "DefringeGreenAmount", "DefringeGreenHueHi", "DefringeGreenHueLo", "DefringePurpleAmount", "DefringePurpleHueHi", "DefringePurpleHueLo", "Dehaze", "DepthImage", "DerivedFrom", "Description", "DigitalZoomRatio", "DisableAutoCreation", "DistortionCorrectionAlreadyApplied", "DocumentID", "DroneModel", "DroneSerialNumber", "Duration", "ExifImageHeight", "ExifImageWidth", "ExifVersion", "Exposure", "ExposureCompensation", "ExposureTime", "Face", "FaceNum", "FaceSelectedIndex", "Far", "FileSource", "Filters", "Firmware", "FlashCompensation", "FlashManufacturer", "FlashModel", "FlashPixVersion", "FlightPitchDegree", "FlightRollDegree", "FlightXSpeed", "FlightYawDegree", "FlightYSpeed", "FlightZSpeed", "FNumber", "FocalLength", "FocalLengthIn35mmFormat", "FocalPlaneResolutionUnit", "FocalPlaneXResolution", "FocalPlaneYResolution", "FocusAreaHeight", "FocusAreaNum", "FocusAreaWidth", "FocusDistance", "FocusIsLensMoving", "FocusPosX", "FocusPosY", "FocusState", "Format", "FullPanoHeightPixels", "FullPanoWidthPixels", "GainControl", "GimbalPitchDegree", "GimbalReverse", "GimbalRollDegree", "GimbalYawDegree", "GPSAltitude", "GPSAltitudeRef", "GPSDateStamp", "GPSDateTime", "GPSDOP", "GPSImgDirection", "GPSImgDirectionRef", "GPSLatitude", "GPSLongitude", "GPSLongitudeRef", "GPSMapDatum", "GPSProcessingMethod", "GpsStatus", "GPSVersionID", "GrainAmount", "GreenHue", "GreenSaturation", "HasCrop", "HasExtendedXMP", "HasSettings", "HDRPlusMakerNote", "HDRPMakerNote", "HierarchicalSubject", "History", "HueAdjustmentAqua", "HueAdjustmentBlue", "HueAdjustmentGreen", "HueAdjustmentMagenta", "HueAdjustmentOrange", "HueAdjustmentPurple", "HueAdjustmentRed", "HueAdjustmentYellow", "ICCProfileName", "ImageData", "ImageHeight", "ImageLength", "ImageMimeType", "ImageNumber", "ImageSource", "ImageWidth", "InitialViewHeadingDegrees", "InitialViewPitchDegrees", "InitialViewRollDegrees", "InstanceID", "InteroperabilityIndex", "InteroperabilityVersion", "IsBokehActive", "IsHDRActive", "IsNightModeActive", "ISO", "ISOSpeed", "Label", "LastKeywordXMP", "LateralChromaticAberrationCorrectionAlreadyApplied", "Lens", "LensFacing", "LensID", "LensInfo", "LensMake", "LensManualDistortionAmount", "LensManufacturer", "LensModel", "LensProfileDigest", "LensProfileDistortionScale", "LensProfileEnable", "LensProfileIsEmbedded", "LensProfileSetup", "LensProfileVignettingScale", "LensSerialNumber", "LightSource", "LocationAreaCode", "Look", "LuminanceAdjustmentAqua", "LuminanceAdjustmentBlue", "LuminanceAdjustmentGreen", "LuminanceAdjustmentMagenta", "LuminanceAdjustmentOrange", "LuminanceAdjustmentPurple", "LuminanceAdjustmentRed", "LuminanceAdjustmentYellow", "LuminanceNoiseReductionContrast", "LuminanceNoiseReductionDetail", "LuminanceSmoothing", "Make", "MakerNote", "Marked", "Mask", "MaxApertureValue", "MetadataDate", "MeteringMode", "MicroVideo", "MicroVideoOffset", "MicroVideoPresentationTimestampUs", "MicroVideoVersion", "Mime", "MinorVersion", "MobileCountryCode", "MobileNetworkCode", "Model", "ModificationDate", "ModifyDate", "MotionPhoto", "MotionPhotoPresentationTimestampUs", "MotionPhotoVersion", "NativeDigest", "Near", "Notes", "ObjectAreaHeight", "ObjectAreaWidth", "ObjectNum", "ObjectPosX", "ObjectPosY", "Orientation", "OriginalCreateDateTime", "OriginalDocumentID", "OverrideLookVignette", "Padding", "ParametricDarks", "ParametricHighlights", "ParametricHighlightSplit", "ParametricLights", "ParametricMidtoneSplit", "ParametricShadows", "ParametricShadowSplit", "PersonInImage", "PerspectiveAspect", "PerspectiveHorizontal", "PerspectiveRotate", "PerspectiveScale", "PerspectiveUpright", "PerspectiveVertical", "PerspectiveX", "PerspectiveY", "PhotographicSensitivity", "PhotometricInterpretation", "PickLabel", "Pitch", "PMVersion", "PortraitVersion", "PoseHeadingDegrees", "PosePitchDegrees", "PoseRollDegrees", "PostCropVignetteAmount", "Prefs", "PreservedFileName", "ProcessVersion", "ProgramMode", "ProjectionType", "Rating", "RawFileName", "RecommendedExposureIndex", "RedHue", "RedSaturation", "RegionInfo", "RegionInfoMP", "RegistryID", "RelativeAltitude", "ResolutionUnit", "Rights", "Roll", "SamplesPerPixel", "Saturation", "SaturationAdjustmentAqua", "SaturationAdjustmentBlue", "SaturationAdjustmentGreen", "SaturationAdjustmentMagenta", "SaturationAdjustmentOrange", "SaturationAdjustmentPurple", "SaturationAdjustmentRed", "SaturationAdjustmentYellow", "Scene", "SceneDetectResultConfidences", "SceneDetectResultIds", "SceneType", "SelfData", "SemanticSegmentationMatteVersion", "SensingMethod", "SensitivityType", "SerialNumber", "Shadows", "ShadowTint", "SharpenDetail", "SharpenEdgeMasking", "SharpenRadius", "ShootingMode", "ShotLogData", "ShutterSpeedValue", "ShutterType", "Software", "Source", "SourcePhotosCount", "SpecialTypeID", "SplitToningBalance", "SplitToningHighlightHue", "SplitToningHighlightSaturation", "SplitToningShadowHue", "SplitToningShadowSaturation", "State", "StitchingSoftware", "StreamType", "Subject", "SubjectDistance", "SubjectDistanceRange", "SubsecTime", "SubSecTimeDigitized", "SubSecTimeOriginal", "SurveyingMode", "Tagged", "TagsList", "Texture", "Tint", "Title", "TlinearGain", "ToneCurve", "ToneCurveName", "ToneCurvePV2012Blue", "ToneCurvePV2012Green", "ToneCurvePV2012Red", "Urgency", "UsePanoramaViewer", "UserComment", "UTCAtExposure", "Versions", "Vibrance", "VignetteAmount", "WavelengthFWHM", "WhiteBalance", "XMPMeta", "XMPToolkit", "XResolution", "Yaw", "YCbCrPositioning", "YResolution");
/**
 * All tag names combined from all interfaces
 */
exports.TagNames = (0, StrEnum_1.strEnum)(...exports.ExifToolTagsNames.values, ...exports.FileTagsNames.values, ...exports.CompositeTagsNames.values, ...exports.APPTagsNames.values, ...exports.DuckyTagsNames.values, ...exports.FlashPixTagsNames.values, ...exports.EXIFTagsNames.values, ...exports.JPEGTagsNames.values, ...exports.JSONTagsNames.values, ...exports.JUMBFTagsNames.values, ...exports.MPFTagsNames.values, ...exports.MetaTagsNames.values, ...exports.PanasonicRawTagsNames.values, ...exports.PhotoshopTagsNames.values, ...exports.PrintIMTagsNames.values, ...exports.IPTCTagsNames.values, ...exports.QuickTimeTagsNames.values, ...exports.RAFTagsNames.values, ...exports.RIFFTagsNames.values, ...exports.JFIFTagsNames.values, ...exports.MakerNotesTagsNames.values, ...exports.XMPTagsNames.values, ...ExifToolVendoredTags_1.ExifToolVendoredTagNames.values, ...GeolocationTags_1.GeolocationTagNames.values, ...ImageDataHashTag_1.ImageDataHashTagNames.values, ...ICCProfileTags_1.ICCProfileTagNames.values, ...IPTCApplicationRecordTags_1.IPTCApplicationRecordTagNames.values, ...MWGTags_1.MWGCollectionsTagNames.values, ...MWGTags_1.MWGKeywordTagNames.values);
//# sourceMappingURL=Tags.js.map