"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var CommandRunnerModule_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CommandRunnerModule = void 0;
const common_1 = require("@nestjs/common");
const nestjs_discovery_1 = require("@golevelup/nestjs-discovery");
const commander_1 = require("commander");
const inquirer = __importStar(require("inquirer"));
const command_runner_service_1 = require("./command-runner.service");
const constants_1 = require("./constants");
const inquirer_service_1 = require("./inquirer.service");
const cli_utility_service_1 = require("./cli-utility.service");
let CommandRunnerModule = CommandRunnerModule_1 = class CommandRunnerModule {
    static forModule(module, options) {
        return {
            global: true,
            module: CommandRunnerModule_1,
            imports: module ? [module, nestjs_discovery_1.DiscoveryModule] : [nestjs_discovery_1.DiscoveryModule],
            providers: [
                common_1.Logger,
                command_runner_service_1.CommandRunnerService,
                inquirer_service_1.InquirerService,
                {
                    provide: constants_1.Commander,
                    useClass: commander_1.Command,
                },
                {
                    provide: constants_1.Inquirer,
                    useValue: inquirer,
                },
                {
                    provide: constants_1.CommanderOptions,
                    useValue: options !== null && options !== void 0 ? options : {},
                },
                {
                    provide: 'InquirerOptions',
                    useValue: this.inquirerOptions,
                },
                cli_utility_service_1.CliUtilityService,
            ],
            exports: [inquirer_service_1.InquirerService, cli_utility_service_1.CliUtilityService, constants_1.Commander],
        };
    }
};
exports.CommandRunnerModule = CommandRunnerModule;
CommandRunnerModule.inquirerOptions = {
    input: process.stdin,
    output: process.stdout,
};
exports.CommandRunnerModule = CommandRunnerModule = CommandRunnerModule_1 = __decorate([
    (0, common_1.Module)({})
], CommandRunnerModule);
//# sourceMappingURL=command-runner.module.js.map