import { Logger, OnModuleInit } from '@nestjs/common';
import { DiscoveryService } from '@golevelup/nestjs-discovery';
import { Command } from 'commander';
import { CommanderOptionsType } from './command-factory.interface';
export declare class CommandRunnerService implements OnModuleInit {
    private readonly discoveryService;
    private commander;
    private readonly options;
    private readonly logger;
    private subCommands?;
    constructor(discoveryService: DiscoveryService, commander: Command, options: CommanderOptionsType, logger: Logger);
    onModuleInit(): Promise<void>;
    /**
     * override the initial `commander` instance to be the `@DefaultCommand()`
     * This will allow for the -h action on a default call of the command to
     * provide the information from the default command and not the overall
     * application.
     */
    private setUpDefaultCommand;
    private populateCommandMapInstances;
    private setUpCommander;
    private buildCommand;
    private mapArgumentDescriptions;
    run(args?: string[]): Promise<void>;
}
