"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InjectCommander = exports.Help = exports.DefaultFor = exports.ChoicesFor = exports.MessageFor = exports.WhenFor = exports.TransformFor = exports.ValidateFor = exports.Question = exports.QuestionSet = exports.OptionChoiceFor = exports.Option = exports.DefaultCommand = exports.RootCommand = exports.SubCommand = exports.Command = void 0;
const common_1 = require("@nestjs/common");
const constants_1 = require("./constants");
const applyMethodMetadata = (options, metadataKey) => {
    return (_target, _propertyKey, descriptor) => {
        Reflect.defineMetadata(metadataKey, options, descriptor.value);
        return descriptor;
    };
};
const applyClassMetadata = (options, metadataKey) => {
    return (target) => {
        Reflect.defineMetadata(metadataKey, options, target);
        return target;
    };
};
const Command = (options) => {
    return applyClassMetadata(options, constants_1.CommandMeta);
};
exports.Command = Command;
const SubCommand = (options) => {
    return applyClassMetadata(options, constants_1.SubCommandMeta);
};
exports.SubCommand = SubCommand;
const RootCommand = (options) => {
    return applyClassMetadata(options, constants_1.RootCommandMeta);
};
exports.RootCommand = RootCommand;
exports.DefaultCommand = exports.RootCommand;
const Option = (options) => {
    return applyMethodMetadata(options, constants_1.OptionMeta);
};
exports.Option = Option;
const OptionChoiceFor = (options) => {
    return applyMethodMetadata(options, constants_1.OptionChoiceMeta);
};
exports.OptionChoiceFor = OptionChoiceFor;
const QuestionSet = (options) => {
    return applyClassMetadata(options, constants_1.QuestionSetMeta);
};
exports.QuestionSet = QuestionSet;
const Question = (options) => {
    return applyMethodMetadata(options, constants_1.QuestionMeta);
};
exports.Question = Question;
const ValidateFor = (options) => {
    return applyMethodMetadata(options, constants_1.ValidateMeta);
};
exports.ValidateFor = ValidateFor;
const TransformFor = (options) => {
    return applyMethodMetadata(options, constants_1.TransformMeta);
};
exports.TransformFor = TransformFor;
const WhenFor = (options) => {
    return applyMethodMetadata(options, constants_1.WhenMeta);
};
exports.WhenFor = WhenFor;
const MessageFor = (options) => {
    return applyMethodMetadata(options, constants_1.MessageMeta);
};
exports.MessageFor = MessageFor;
const ChoicesFor = (options) => {
    return applyMethodMetadata(options, constants_1.ChoicesMeta);
};
exports.ChoicesFor = ChoicesFor;
const DefaultFor = (options) => {
    return applyMethodMetadata(options, constants_1.DefaultMeta);
};
exports.DefaultFor = DefaultFor;
const Help = (options) => {
    return applyMethodMetadata(options, constants_1.HelpMeta);
};
exports.Help = Help;
const InjectCommander = () => (0, common_1.Inject)(constants_1.Commander);
exports.InjectCommander = InjectCommander;
//# sourceMappingURL=command.decorators.js.map