import type { INestApplicationContext } from '@nestjs/common';
import { Command } from 'commander';
import type { CompletionFactoryOptions } from './completion.factory.interface';
/**
 * @description Factory to generate completion script for BASH and ZSH
 */
export declare class CompletionFactory {
    /**
     * @description Register the completion command for either Bash, ZSH or Fig
     * @usage
     * ### Fig completion
     * Applying new command to generate the completion spec
     * @see https://fig.io/docs/guides/private-autocomplete
     *
     * @see https://fig.io/docs/guides/autocomplete-for-internal-tools
     *
     * ### Bash & ZSH completion
     * Put this script in your .bashrc or .zshrc
     * ```bash
     * source <(YOUR-CLI-NAMESPACE completion-script)
     * ```
     * @param options - {@link CompletionFactoryOptions}
     */
    static registerCompletionCommand(app: INestApplicationContext, options: CompletionFactoryOptions): Promise<void>;
    protected static getOptions(options: CompletionFactoryOptions): CompletionFactoryOptions;
    protected static setupNativeShellCompletion(commander: Command, cmd: string, executablePath: string): void;
    protected static generateCompletionScript(executablePath: string, cliName: string, command: string, isZsh: boolean): string;
    protected static defaultCompletion(command: Command | null): string[];
    protected static commandCompletions(completions: string[], command: Command): void;
    protected static optionCompletions(completions: string[], command: Command): void;
    protected static getCompletion(command: Command): string[];
}
