"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.InquirerService = void 0;
const nestjs_discovery_1 = require("@golevelup/nestjs-discovery");
const common_1 = require("@nestjs/common");
const constants_1 = require("./constants");
let InquirerService = class InquirerService {
    constructor(inquirer, discoveryService) {
        this.inquirer = inquirer;
        this.discoveryService = discoveryService;
        this.inquirerKeyToMetadataKeyMap = {
            transformer: constants_1.TransformMeta,
            when: constants_1.WhenMeta,
            validate: constants_1.ValidateMeta,
            message: constants_1.MessageMeta,
            default: constants_1.DefaultMeta,
            choices: constants_1.ChoicesMeta,
        };
        this.ask = this.prompt;
    }
    async prompt(questionSetName, options) {
        const rawQuestions = await this.findQuestionSet(questionSetName);
        const questions = await this.mapMetaQuestionToQuestion(rawQuestions);
        const answers = await this.inquirer.prompt(questions, options);
        return answers;
    }
    async findQuestionSet(questionSetName) {
        const classes = await this.discoveryService.providersWithMetaAtKey(constants_1.QuestionSetMeta);
        const cls = classes.filter((c) => c.meta.name === questionSetName)[0];
        const questions = await this.discoveryService.providerMethodsWithMetaAtKey(constants_1.QuestionMeta, (found) => found.name === cls.discoveredClass.name);
        return questions;
    }
    async mapMetaQuestionToQuestion(rawQuestions) {
        const extraMetas = {};
        for (const iKey of Object.keys(this.inquirerKeyToMetadataKeyMap)) {
            const metaKey = this.inquirerKeyToMetadataKeyMap[iKey];
            const foundMeta = await this.discoveryService.providerMethodsWithMetaAtKey(metaKey, (found) => found.name === rawQuestions[0].discoveredMethod.parentClass.name);
            extraMetas[iKey] = foundMeta !== null && foundMeta !== void 0 ? foundMeta : [];
        }
        const questions = await this.parseRawQuestionMetadata(rawQuestions, extraMetas);
        return questions.sort((a, b) => { var _a, _b; return ((_a = a.index) !== null && _a !== void 0 ? _a : 0) - ((_b = b.index) !== null && _b !== void 0 ? _b : 0); });
    }
    async parseRawQuestionMetadata(rawQuestions, extraMetas) {
        const questions = [];
        for (const q of rawQuestions) {
            const { meta, discoveredMethod } = q;
            const retQ = {};
            for (const key of Object.keys(meta)) {
                if (typeof meta[key] === 'function') {
                    retQ[key] = meta[key].bind(discoveredMethod.parentClass.instance);
                }
                else {
                    retQ[key] = meta[key];
                }
            }
            retQ.filter = discoveredMethod.handler.bind(discoveredMethod.parentClass.instance);
            for (const iKey of Object.keys(this.inquirerKeyToMetadataKeyMap)) {
                const metas = extraMetas[iKey];
                const iKeyMetaForQuestion = metas.find((extraMeta) => extraMeta.meta.name === meta.name);
                if (iKeyMetaForQuestion) {
                    retQ[iKey] = iKeyMetaForQuestion.discoveredMethod.handler.bind(iKeyMetaForQuestion.discoveredMethod.parentClass.instance);
                }
            }
            questions.push(retQ);
        }
        return questions;
    }
};
exports.InquirerService = InquirerService;
exports.InquirerService = InquirerService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)(constants_1.Inquirer)),
    __metadata("design:paramtypes", [Object, nestjs_discovery_1.DiscoveryService])
], InquirerService);
//# sourceMappingURL=inquirer.service.js.map