"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClsGuard = void 0;
const common_1 = require("@nestjs/common");
const cls_service_manager_1 = require("../cls-service-manager");
const cls_constants_1 = require("../cls.constants");
const cls_internal_constants_1 = require("../cls.internal-constants");
const cls_options_1 = require("../cls.options");
const context_cls_store_map_1 = require("./utils/context-cls-store-map");
let ClsGuard = class ClsGuard {
    constructor(options) {
        this.options = { ...new cls_options_1.ClsGuardOptions(), ...options };
    }
    async canActivate(context) {
        const cls = cls_service_manager_1.ClsServiceManager.getClsService();
        const existingStore = context_cls_store_map_1.ContextClsStoreMap.get(context);
        if (existingStore) {
            cls.enter({ ifNested: 'reuse' });
        }
        else {
            cls.enterWith({});
            context_cls_store_map_1.ContextClsStoreMap.set(context, cls.get());
        }
        if (this.options.generateId) {
            const id = await this.options.idGenerator?.(context);
            cls.setIfUndefined(cls_constants_1.CLS_ID, id);
        }
        if (this.options.saveCtx) {
            cls.set(cls_constants_1.CLS_CTX, context);
        }
        if (this.options.setup) {
            await this.options.setup(cls, context);
        }
        if (this.options.initializePlugins) {
            await cls.initializePlugins();
        }
        if (this.options.resolveProxyProviders) {
            await cls.resolveProxyProviders();
        }
        return true;
    }
};
exports.ClsGuard = ClsGuard;
exports.ClsGuard = ClsGuard = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)(cls_internal_constants_1.CLS_GUARD_OPTIONS)),
    __metadata("design:paramtypes", [Object])
], ClsGuard);
//# sourceMappingURL=cls.guard.js.map